/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3715;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_557;
import net.minecraft.class_5602;
import net.minecraft.class_761;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class LecternAnimation
extends Animation {
    private final class_557 bookModel = new class_557(class_310.method_1551().method_31974().method_32072(class_5602.field_27685));
    private final float hash;

    public LecternAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.hash = position.hashCode();
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.LECTERN_SPEED.getValue();
    }

    @Override
    public double getLifeSpan() {
        return !LecternAnimation.hasInfiniteAnimation() || !this.newIsOpen ? this.getAnimDuration() : Double.MAX_VALUE;
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.LECTERN_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.LECTERN_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.LECTERN_INFINITE.getValue();
    }

    private double getAngle(double progress) {
        double startAngle = this.oldIsOpen ? 1.2 : 0.0;
        double endAngle = this.newIsOpen ? 1.2 : 0.0;
        return startAngle + (endAngle - startAngle) * progress;
    }

    private float getPageAngle(float defaultVal, double nowTick) {
        float time = (float)(nowTick - this.startTick);
        if ((double)time <= this.getAnimDuration()) {
            return defaultVal;
        }
        float uniqueOffset = (this.hash + defaultVal * 67.0f) % 100.0f;
        float slowWave = (float)Math.sin((time += uniqueOffset) * 0.1f) * 0.05f;
        float fastWave = (float)Math.sin(time * 0.25f) * 0.02f;
        return defaultVal + (slowWave + fastWave) / 2.0f;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_3715.field_16404);
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23578((class_2960)class_2960.method_12829((String)"minecraft:textures/entity/enchanting_table_book.png")));
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        this.bookModel.method_17073(0.0f, this.getPageAngle(0.1f, nowTick), this.getPageAngle(0.9f, nowTick), (float)this.getAngle(Curves.ease(this.getProgress(nowTick), this.getCurve())));
        poseStack.method_46416(0.5f, 1.0625f, 0.5f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-facing.method_10170().method_10144()));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(67.5f));
        poseStack.method_46416(0.0f, -0.125f, 0.0f);
        this.bookModel.method_60879(poseStack, buffer, light, class_4608.field_21444);
    }
}

