/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2533;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class TrapDoorAnimation
extends Animation {
    public TrapDoorAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.TRAPDOOR_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.TRAPDOOR_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.TRAPDOOR_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen, class_2350 hingeSide) {
        if (!isOpen) {
            return 0.0;
        }
        return hingeSide == class_2350.field_11043 || hingeSide == class_2350.field_11034 ? 90.0 : -90.0;
    }

    private double getAngle(double nowTick, class_2350 hingeSide) {
        double angle1 = this.getStartAngle(this.oldIsOpen, hingeSide);
        double angle2 = this.getStartAngle(this.newIsOpen, hingeSide);
        return angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_2533.field_11177);
        class_2760 half = (class_2760)this.defaultState.method_11654((class_2769)class_2533.field_11625);
        class_265 collShape = this.defaultState.method_26220((class_1922)class_310.method_1551().field_1687, class_2338.field_10980);
        class_238 boundingBox = collShape.method_1110() ? this.defaultState.method_26218((class_1922)class_310.method_1551().field_1687, class_2338.field_10980).method_1107() : collShape.method_1107();
        class_2350 hingeSide = facing.method_10153();
        double angle = this.getAngle(nowTick, hingeSide);
        if (half == class_2760.field_12617) {
            angle = -angle;
        }
        float pivotX = (float)((boundingBox.field_1323 + boundingBox.field_1320) * 0.5);
        float pivotZ = (float)((boundingBox.field_1321 + boundingBox.field_1324) * 0.5);
        switch (hingeSide) {
            case field_11034: {
                pivotX = (float)boundingBox.field_1320;
                break;
            }
            case field_11039: {
                pivotX = (float)boundingBox.field_1323;
                break;
            }
            case field_11035: {
                pivotZ = (float)boundingBox.field_1324;
                break;
            }
            case field_11043: {
                pivotZ = (float)boundingBox.field_1321;
                break;
            }
        }
        float pivotY = half == class_2760.field_12619 ? (float)boundingBox.field_1325 : (float)boundingBox.field_1322;
        float thickness = (float)(boundingBox.field_1325 - boundingBox.field_1322);
        float halfThickness = thickness > 0.0f ? thickness * 0.5f : 0.09375f;
        float dY = half == class_2760.field_12619 ? -halfThickness : halfThickness;
        double rad = Math.toRadians(angle);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        float shiftZ = 0.0f;
        if (hingeSide == class_2350.field_11043 || hingeSide == class_2350.field_11035) {
            float rotY = dY * cos;
            float rotZ = dY * sin;
            shiftY = dY - rotY;
            shiftZ = -rotZ;
        } else {
            float rotX = -dY * sin;
            float rotY = dY * cos;
            shiftX = -rotX;
            shiftY = dY - rotY;
        }
        poseStack.method_46416(shiftX, shiftY, shiftZ);
        poseStack.method_46416(pivotX, pivotY, pivotZ);
        if (hingeSide == class_2350.field_11043 || hingeSide == class_2350.field_11035) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)angle));
        } else {
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)angle));
        }
        poseStack.method_46416(-pivotX, -pivotY, -pivotZ);
        poseStack.method_46416(-shiftX, -shiftY, -shiftZ);
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_310.method_1551().method_1541().method_3353(this.defaultState, poseStack, (class_4597)bufferSource, light, class_4608.field_21444);
    }
}

