/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.config;

import fr.madu59.fwa.config.SettingsManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;

@Environment(value=EnvType.CLIENT)
public class Option<T> {
    private String id;
    private String name;
    private String description;
    private T value;
    private T defaultValue;

    public Option(String id, String name, String description, T value, T defaultValue) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.value = value;
        this.defaultValue = defaultValue;
        SettingsManager.ALL_OPTIONS.add(this);
    }

    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return class_1074.method_4662((String)this.name, (Object[])new Object[0]);
    }

    public String getDescription() {
        return class_1074.method_4662((String)this.description, (Object[])new Object[0]);
    }

    public void setToNextValue() {
        this.value = this.cycle(this.value);
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public T cycle(T value) {
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            Enum[] constants = (Enum[])enumValue.getDeclaringClass().getEnumConstants();
            int nextOrdinal = (enumValue.ordinal() + 1) % constants.length;
            return (T)constants[nextOrdinal];
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            return (T)Boolean.valueOf(boolValue == false);
        }
        return null;
    }
}

