/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Backport;
import fr.madu59.fwa.utils.Curves;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class FenceGateAnimation
extends Animation {
    private final class_5819 random = class_5819.method_43049((long)42L);

    public FenceGateAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.FENCEGATE_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.FENCEGATE_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.FENCEGATE_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen) {
        if (!isOpen) {
            return 0.0;
        }
        return 90.0;
    }

    private double getAngle(double nowTick, class_2350 facing) {
        double angle1 = this.getStartAngle(this.oldIsOpen);
        double angle2 = this.getStartAngle(this.newIsOpen);
        double finalAngle = angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
        if (facing == class_2350.field_11043 || facing == class_2350.field_11039) {
            finalAngle = -finalAngle;
        }
        return finalAngle;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_2349.field_11177);
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_4588 buffer = bufferSource.getBuffer(class_4696.method_23683((class_2680)this.defaultState));
        class_1087 model = class_310.method_1551().method_1541().method_3349(this.defaultState);
        ArrayList<class_777> quads = new ArrayList<class_777>();
        for (class_2350 dir : class_2350.values()) {
            quads.addAll(model.method_4707(this.defaultState, dir, this.random));
        }
        quads.addAll(model.method_4707(this.defaultState, null, this.random));
        FenceGate fenceGate = this.splitFenceGateQuads(quads, facing);
        for (class_777 quad : fenceGate.postQuadList) {
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
        boolean onAxisZ = facing.method_10166() == class_2350.class_2351.field_11051;
        float leftPivotX = onAxisZ ? 0.0625f : 0.5f;
        float leftPivotZ = onAxisZ ? 0.5f : 0.0625f;
        float rightPivotX = onAxisZ ? 0.9375f : 0.5f;
        float rightPivotZ = onAxisZ ? 0.5f : 0.9375f;
        float angle = (float)this.getAngle(nowTick, facing);
        float leftAngle = onAxisZ ? -angle : angle;
        float rightAngle = onAxisZ ? angle : -angle;
        poseStack.method_46416(leftPivotX, 0.0f, leftPivotZ);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(leftAngle));
        poseStack.method_46416(-leftPivotX, 0.0f, -leftPivotZ);
        for (class_777 quad : fenceGate.leftQuadList) {
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
        poseStack.method_46416(leftPivotX, 0.0f, leftPivotZ);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-leftAngle));
        poseStack.method_46416(-leftPivotX, 0.0f, -leftPivotZ);
        poseStack.method_46416(rightPivotX, 0.0f, rightPivotZ);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rightAngle));
        poseStack.method_46416(-rightPivotX, 0.0f, -rightPivotZ);
        for (class_777 quad : fenceGate.rightQuadList) {
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }

    public FenceGate splitFenceGateQuads(List<class_777> quads, class_2350 facing) {
        ArrayList<class_777> post = new ArrayList<class_777>();
        ArrayList<class_777> left = new ArrayList<class_777>();
        ArrayList<class_777> right = new ArrayList<class_777>();
        for (class_777 quad : quads) {
            float max;
            float min;
            Vector3f pos1 = Backport.getPos(quad, 0);
            Vector3f pos2 = Backport.getPos(quad, 1);
            Vector3f pos3 = Backport.getPos(quad, 2);
            Vector3f pos4 = Backport.getPos(quad, 3);
            if (facing.method_10166() == class_2350.class_2351.field_11048) {
                min = Math.min(pos1.z(), Math.min(pos2.z(), Math.min(pos3.z(), pos4.z())));
                max = Math.max(pos1.z(), Math.max(pos2.z(), Math.max(pos3.z(), pos4.z())));
            } else {
                min = Math.min(pos1.x(), Math.min(pos2.x(), Math.min(pos3.x(), pos4.x())));
                max = Math.max(pos1.x(), Math.max(pos2.x(), Math.max(pos3.x(), pos4.x())));
            }
            if (min >= 0.125f && max <= 0.875f && (max != min || !(max <= 0.125f) && !(max >= 0.875f))) {
                if (min == 0.5f && max == 0.5f) {
                    right.add(quad);
                    left.add(quad);
                    continue;
                }
                if (min >= 0.5f && max >= 0.5f) {
                    right.add(quad);
                    continue;
                }
                left.add(quad);
                continue;
            }
            post.add(quad);
        }
        return new FenceGate(this, post, left, right);
    }

    @Environment(value=EnvType.CLIENT)
    public class FenceGate {
        List<class_777> postQuadList;
        List<class_777> leftQuadList;
        List<class_777> rightQuadList;

        public FenceGate(FenceGateAnimation this$0, List<class_777> postQuadList, List<class_777> leftQuadList, List<class_777> rightQuadList) {
            this.postQuadList = postQuadList;
            this.leftQuadList = leftQuadList;
            this.rightQuadList = rightQuadList;
        }
    }
}

