/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.mixin.client.GetContentHeightInvoker;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5546;
import net.minecraft.class_5553;
import net.minecraft.class_5556;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class LayeredCauldronAnimation
extends Animation {
    private final class_2680 oldState;
    private final class_2680 newState;
    private final boolean isInverted;
    private final class_5819 random = class_5819.method_43049((long)42L);
    private final class_1087 model;

    public LayeredCauldronAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 newBlockState, class_2680 oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        if (newBlockState.method_26204() instanceof class_5546) {
            this.newState = oldBlockState;
            this.oldState = newBlockState;
            this.isInverted = true;
        } else {
            this.newState = newBlockState;
            this.oldState = oldBlockState;
            this.isInverted = false;
        }
        this.model = class_310.method_1551().method_1541().method_3349(this.newState);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.CAULDRON_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.CAULDRON_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.CAULDRON_STATE.getValue();
    }

    private float getPosition(double nowTick, double newPos, double oldPos) {
        if (this.isInverted) {
            return (float)((oldPos - newPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
        }
        return (float)(oldPos - newPos - (oldPos - newPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
    }

    private double getHeight(class_2680 state) {
        if (state.method_26204() instanceof class_5556) {
            return ((GetContentHeightInvoker)state.method_26204()).fwa$getContentHeight(state);
        }
        if (state.method_26204() instanceof class_5553) {
            return 0.9375;
        }
        return 0.25;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_4588 buffer = bufferSource.getBuffer(class_4696.method_23683((class_2680)this.newState, (boolean)true));
        this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.newState, null, this.random), false, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.newState, dir, this.random), false, light);
        }
        float dy = this.getPosition(nowTick, this.getHeight(this.newState), this.getHeight(this.oldState));
        poseStack.method_46416(0.0f, dy, 0.0f);
        this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.newState, null, this.random), true, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.newState, dir, this.random), true, light);
        }
    }

    private void renderFilteredQuads(class_4587 poseStack, class_4588 buffer, List<class_777> quads, boolean wantLiquid, int light) {
        for (class_777 quad : quads) {
            String path = quad.method_35788().method_45851().method_45816().method_12832();
            if (path.contains("cauldron") == wantLiquid) continue;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.method_3360()) {
                int color = class_310.method_1551().method_1505().method_1697(this.newState, (class_1920)class_310.method_1551().field_1687, this.position, quad.method_3359());
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            }
            buffer.method_22919(poseStack.method_23760(), quad, r, g, b, 1.0f, light, class_4608.field_21444);
        }
    }
}

