/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Backport;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2462;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class RepeaterAnimation
extends Animation {
    private final class_2680 oldState;
    private final class_2680 newState;
    private final class_5819 random = class_5819.method_43049((long)42L);
    private final class_1087 model;

    public RepeaterAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 newBlockState, class_2680 oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newBlockState;
        this.oldState = oldBlockState;
        this.model = class_310.method_1551().method_1541().method_3349(defaultState);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.REPEATER_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.REPEATER_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.REPEATER_STATE.getValue();
    }

    private float getPosition(double nowTick, int newPos, int oldPos) {
        return (float)((double)oldPos + (double)(newPos - oldPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_2462.field_11177);
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_4588 buffer = bufferSource.getBuffer(class_4696.method_23683((class_2680)this.defaultState, (boolean)true));
        this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.defaultState, null, this.random), false, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.defaultState, dir, this.random), false, light);
        }
        float dx = this.getPosition(nowTick, (Integer)this.newState.method_11654((class_2769)class_2462.field_11451), (Integer)this.oldState.method_11654((class_2769)class_2462.field_11451));
        dx = (dx - 1.0f) * 2.0f / 16.0f * (float)facing.method_10171().method_10181();
        if (facing.method_10166() == class_2350.class_2351.field_11048) {
            poseStack.method_46416(dx, 0.0f, 0.0f);
        } else {
            poseStack.method_46416(0.0f, 0.0f, dx);
        }
        this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.defaultState, null, this.random), true, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, this.model.method_4707(this.defaultState, dir, this.random), true, light);
        }
    }

    private void renderFilteredQuads(class_4587 poseStack, class_4588 buffer, List<class_777> quads, boolean wantTorch, int light) {
        for (class_777 quad : quads) {
            String path = quad.method_35788().method_45851().method_45816().method_12832();
            if ((path.contains("redstone_torch") && Backport.getPos(quad, 0).x() > 0.3125f && Backport.getPos(quad, 0).x() < 0.6875f && Backport.getPos(quad, 2).x() > 0.3125f && Backport.getPos(quad, 2).x() < 0.6875f && Backport.getPos(quad, 0).z() > 0.3125f && Backport.getPos(quad, 0).z() < 0.6875f && Backport.getPos(quad, 2).z() > 0.3125f && Backport.getPos(quad, 2).z() < 0.6875f) != wantTorch) continue;
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }
}

