/*
 * Decompiled with CFR 0.152.
 */
package com.example.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="flowhud")
public class FlowHudConfig
implements ConfigData {
    @ConfigEntry.Category(value="default")
    public boolean disableShake = true;
    @ConfigEntry.Category(value="default")
    public float hudScale = 1.0f;
    @ConfigEntry.Category(value="default")
    public boolean enableTntTimer = true;
    @ConfigEntry.Category(value="default")
    public boolean enablePlayerHealth = true;
    @ConfigEntry.Category(value="colors")
    @ConfigEntry.ColorPicker(allowAlpha=true)
    public int goodColor = -11141291;
    @ConfigEntry.Category(value="colors")
    @ConfigEntry.ColorPicker(allowAlpha=true)
    public int badColor = -43691;
    @ConfigEntry.Category(value="colors")
    @ConfigEntry.ColorPicker(allowAlpha=true)
    public int accentColor = -11141121;
    @ConfigEntry.Category(value="positions")
    public HudPositions positions = new HudPositions();

    public static class HudPositions {
        public ElementPos armor = new ElementPos(Anchor.RIGHT, -25, Anchor.BOTTOM, -20);
        public ElementPos mainHand = new ElementPos(Anchor.CENTER, 98, Anchor.BOTTOM, -19);
        public ElementPos offHand = new ElementPos(Anchor.CENTER, -118, Anchor.BOTTOM, -19);
        public ElementPos fps = new ElementPos(Anchor.LEFT, 10, Anchor.BOTTOM, -72);
        public ElementPos ping = new ElementPos(Anchor.LEFT, 10, Anchor.BOTTOM, -56);
        public ElementPos tps = new ElementPos(Anchor.LEFT, 10, Anchor.BOTTOM, -40);
        public ElementPos potions = new ElementPos(Anchor.RIGHT, -10, Anchor.TOP, 10);
        public ElementPos pickupLog = new ElementPos(Anchor.RIGHT, 0, Anchor.BOTTOM, -100);
        public ElementPos layout = new ElementPos(Anchor.LEFT, 10, Anchor.BOTTOM, -10);
        public ElementPos ammo = new ElementPos(Anchor.CENTER, 0, Anchor.BOTTOM, -85);
        public ElementPos mace = new ElementPos(Anchor.CENTER, 0, Anchor.CENTER, 30);
    }

    public static class ElementPos {
        public boolean enabled = true;
        public Anchor xAnchor;
        public int xOffset;
        public Anchor yAnchor;
        public int yOffset;

        public ElementPos() {
        }

        public ElementPos(Anchor xA, int xO, Anchor yA, int yO) {
            this.xAnchor = xA;
            this.xOffset = xO;
            this.yAnchor = yA;
            this.yOffset = yO;
        }

        public int getX(int sw, int ew) {
            Anchor a = this.xAnchor != null ? this.xAnchor : Anchor.LEFT;
            return switch (a.ordinal()) {
                case 1 -> sw / 2 - ew / 2 + this.xOffset;
                case 2 -> sw - ew + this.xOffset;
                default -> this.xOffset;
            };
        }

        public int getY(int sh, int eh) {
            Anchor a = this.yAnchor != null ? this.yAnchor : Anchor.TOP;
            return switch (a.ordinal()) {
                case 1 -> sh / 2 - eh / 2 + this.yOffset;
                case 4 -> sh - eh + this.yOffset;
                default -> this.yOffset;
            };
        }
    }

    public static enum Anchor {
        LEFT,
        CENTER,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

