/*
 * Decompiled with CFR 0.152.
 */
package com.example.util;

import net.minecraft.class_332;
import net.minecraft.class_3532;

public class RenderUtils {
    public static final int BORDER = 0x25FFFFFF;

    public static int setAlpha(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int applyChatDim(int color, int x, int y, int w, int h, boolean isChatOpen, int screenH) {
        if (!isChatOpen) {
            return color;
        }
        if (y + h > screenH - 35) {
            int alpha = color >> 24 & 0xFF;
            return RenderUtils.setAlpha(color, alpha / 4);
        }
        return color;
    }

    public static int getDurabilityColor(float pct) {
        float hue = Math.max(0.0f, pct) / 3.0f;
        return class_3532.method_15369((float)hue, (float)1.0f, (float)1.0f) | 0xFF000000;
    }

    public static int getTintedBg(int color, int alpha) {
        int r = (color >> 16 & 0xFF) / 8;
        int g = (color >> 8 & 0xFF) / 8;
        int b = (color & 0xFF) / 8;
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    public static int lerpColor(int c1, int c2, float delta) {
        int a = class_3532.method_48781((float)delta, (int)(c1 >> 24 & 0xFF), (int)(c2 >> 24 & 0xFF));
        int r = class_3532.method_48781((float)delta, (int)(c1 >> 16 & 0xFF), (int)(c2 >> 16 & 0xFF));
        int g = class_3532.method_48781((float)delta, (int)(c1 >> 8 & 0xFF), (int)(c2 >> 8 & 0xFF));
        int b = class_3532.method_48781((float)delta, (int)(c1 & 0xFF), (int)(c2 & 0xFF));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void drawModernBox(class_332 context, int x, int y, int w, int h, int accent, int bg, boolean showAccent) {
        context.method_25294(x + 2, y, x + w - 2, y + h, bg);
        context.method_25294(x, y + 2, x + 2, y + h - 2, bg);
        context.method_25294(x + w - 2, y + 2, x + w, y + h - 2, bg);
        context.method_25294(x + 1, y + 1, x + 2, y + 2, bg);
        context.method_25294(x + w - 2, y + 1, x + w - 1, y + 2, bg);
        context.method_25294(x + 1, y + h - 2, x + 2, y + h - 1, bg);
        context.method_25294(x + w - 2, y + h - 2, x + w - 1, y + h - 1, bg);
        if (showAccent) {
            context.method_25294(x, y + 2, x + 1, y + h - 2, accent);
        }
        context.method_25294(x + 2, y, x + w - 2, y + 1, 0x25FFFFFF);
        context.method_25294(x + 2, y + h - 1, x + w - 2, y + h, 0x25FFFFFF);
    }
}

