/*
 * Decompiled with CFR 0.152.
 */
package com.example.util;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import java.awt.im.InputContext;

public class SystemUtil {
    public static String getKeyboardLayout() {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                WinDef.HWND hwnd = User32.INSTANCE.GetForegroundWindow();
                int threadId = User32.INSTANCE.GetWindowThreadProcessId(hwnd, null);
                WinDef.HKL hkl = User32.INSTANCE.GetKeyboardLayout(threadId);
                if (hkl == null) {
                    return "??";
                }
                long layoutValue = Pointer.nativeValue((Pointer)hkl.getPointer());
                int langId = (int)(layoutValue & 0xFFFFL);
                if (langId == 1049) {
                    return "RU";
                }
                if (langId == 1033 || langId == 2057) {
                    return "EN";
                }
                return "ID:" + Integer.toHexString(langId).toUpperCase();
            }
            return InputContext.getInstance().getLocale().getLanguage().toUpperCase();
        }
        catch (Exception e) {
            return "??";
        }
    }
}

