/*
 * Decompiled with CFR 0.152.
 */
package inchutter.contagiouseffects;

import inchutter.contagiouseffects.ModConfig;
import inchutter.contagiouseffects.SpreadCooldownTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public final class EffectSpreadService {
    private final ModConfig config;
    private final SpreadCooldownTracker cooldowns;
    private long tickCounter = 0L;

    public EffectSpreadService(ModConfig config, SpreadCooldownTracker cooldowns) {
        this.config = config;
        this.cooldowns = cooldowns;
    }

    public void onServerTick(MinecraftServer server) {
        ++this.tickCounter;
        int interval = Math.max(1, this.config.scanIntervalTicks());
        if (this.tickCounter % (long)interval != 0L) {
            return;
        }
        List players = server.method_3760().method_14571();
        if (players.size() < 2) {
            return;
        }
        double range = Math.max(0.1, this.config.rangeBlocks());
        double rangeSq = range * range;
        for (class_3222 source : players) {
            Collection sourceEffects;
            if (!this.isEligible(source) || (sourceEffects = source.method_6026()).isEmpty()) continue;
            ArrayList<class_1293> effectsSnapshot = new ArrayList<class_1293>(sourceEffects);
            for (class_3222 target : players) {
                if (target == source || target.method_51469() != source.method_51469() || !this.isEligible(target) || source.method_5858((class_1297)target) > rangeSq) continue;
                this.spreadEffects(source, target, effectsSnapshot);
            }
        }
        this.cooldowns.cleanup(this.tickCounter);
    }

    private boolean isEligible(class_3222 player) {
        if (!player.method_5805()) {
            return false;
        }
        if (this.config.ignoreSpectator() && player.method_7325()) {
            return false;
        }
        return !this.config.ignoreCreative() || !player.method_68878();
    }

    private void spreadEffects(class_3222 source, class_3222 target, List<class_1293> effects) {
        for (class_1293 sourceInst : effects) {
            class_1293 copy;
            boolean applied;
            class_6880 effect = sourceInst.method_5579();
            if (!this.cooldowns.canApply(source.method_5667(), target.method_5667(), (class_6880<class_1291>)effect, this.tickCounter)) continue;
            class_1293 targetInst = target.method_6112(effect);
            if (this.config.applyIfStrongerOnly() && !EffectSpreadService.shouldOverride(targetInst, sourceInst) || !(applied = target.method_37222(copy = EffectSpreadService.copyInstance(sourceInst), (class_1297)source))) continue;
            this.cooldowns.markApplied(source.method_5667(), target.method_5667(), (class_6880<class_1291>)effect, this.tickCounter);
        }
    }

    private static boolean shouldOverride(class_1293 current, class_1293 incoming) {
        if (current == null) {
            return true;
        }
        int curAmp = current.method_5578();
        int inAmp = incoming.method_5578();
        if (inAmp > curAmp) {
            return true;
        }
        if (inAmp < curAmp) {
            return false;
        }
        return incoming.method_5584() > current.method_5584() + 20;
    }

    private static class_1293 copyInstance(class_1293 src) {
        return new class_1293(src.method_5579(), src.method_5584(), src.method_5578(), src.method_5591(), src.method_5581(), src.method_5592());
    }
}

