/*
 * Decompiled with CFR 0.152.
 */
package inchutter.contagiouseffects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import inchutter.contagiouseffects.ContagiousEffects;
import inchutter.contagiouseffects.ModConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class ModConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "contagious-effects.json";

    private ModConfigLoader() {
    }

    public static ModConfig loadOrCreate() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        if (!Files.exists(configPath, new LinkOption[0])) {
            ModConfig defaults = ModConfig.defaults();
            ModConfigLoader.write(configPath, defaults);
            return defaults;
        }
        try {
            String json = Files.readString(configPath, StandardCharsets.UTF_8);
            ModConfig cfg = (ModConfig)GSON.fromJson(json, ModConfig.class);
            if (cfg == null) {
                ContagiousEffects.LOGGER.warn("Config file was empty/invalid JSON, using defaults.");
                return ModConfig.defaults();
            }
            return ModConfigLoader.sanitize(cfg);
        }
        catch (Exception e) {
            ContagiousEffects.LOGGER.warn("Failed to read config, using defaults.", (Throwable)e);
            return ModConfig.defaults();
        }
    }

    private static ModConfig sanitize(ModConfig cfg) {
        int cooldown;
        int interval;
        double range;
        double d = range = Double.isFinite(cfg.rangeBlocks()) ? cfg.rangeBlocks() : ModConfig.defaults().rangeBlocks();
        if (range < 0.1) {
            range = 0.1;
        }
        if (range > 64.0) {
            range = 64.0;
        }
        if ((interval = cfg.scanIntervalTicks()) < 1) {
            interval = 1;
        }
        if (interval > 200) {
            interval = 200;
        }
        if ((cooldown = cfg.cooldownTicks()) < 0) {
            cooldown = 0;
        }
        if (cooldown > 1200) {
            cooldown = 1200;
        }
        return new ModConfig(range, interval, cooldown, cfg.applyIfStrongerOnly(), cfg.ignoreSpectator(), cfg.ignoreCreative());
    }

    public static void save(ModConfig cfg) {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        ModConfigLoader.write(configPath, cfg);
    }

    private static void write(Path path, ModConfig cfg) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GSON.toJson((Object)cfg), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            ContagiousEffects.LOGGER.warn("Failed to write default config to disk.", (Throwable)e);
        }
    }
}

