/*
 * Decompiled with CFR 0.152.
 */
package inchutter.contagiouseffects;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class SpreadCooldownTracker {
    private final int cooldownTicks;
    private final Map<Key, Long> lastAppliedTickByKey = new HashMap<Key, Long>();

    public SpreadCooldownTracker(int cooldownTicks) {
        this.cooldownTicks = Math.max(0, cooldownTicks);
    }

    public boolean canApply(UUID source, UUID target, class_6880<class_1291> effect, long currentTick) {
        if (this.cooldownTicks <= 0) {
            return true;
        }
        int effectId = class_7923.field_41174.method_10206((Object)((class_1291)effect.comp_349()));
        if (effectId < 0) {
            return true;
        }
        Long last = this.lastAppliedTickByKey.get(new Key(source, target, effectId));
        return last == null || currentTick - last >= (long)this.cooldownTicks;
    }

    public void markApplied(UUID source, UUID target, class_6880<class_1291> effect, long currentTick) {
        int effectId = class_7923.field_41174.method_10206((Object)((class_1291)effect.comp_349()));
        if (effectId < 0) {
            return;
        }
        this.lastAppliedTickByKey.put(new Key(source, target, effectId), currentTick);
    }

    public void cleanup(long currentTick) {
        if (this.cooldownTicks <= 0) {
            return;
        }
        long expireAfter = Math.max(200L, (long)this.cooldownTicks * 5L);
        Iterator<Map.Entry<Key, Long>> it = this.lastAppliedTickByKey.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Key, Long> e = it.next();
            if (currentTick - e.getValue() <= expireAfter) continue;
            it.remove();
        }
    }

    private record Key(UUID source, UUID target, int effectId) {
    }
}

