/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld;

import net.minecraft.resources.Identifier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.sashakyotoz.variousworld.common.config.ConfiguredData;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWEntities;
import net.sashakyotoz.variousworld.init.VWFeatures;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import net.sashakyotoz.variousworld.init.VWRegistryHelper;
import net.sashakyotoz.variousworld.init.VWSounds;
import net.sashakyotoz.variousworld.init.VWTags;
import net.sashakyotoz.variousworld.init.VWVillagers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="various_world")
public class VariousWorld {
    public static final Logger LOGGER = LogManager.getLogger(VariousWorld.class);
    public static final String MOD_ID = "various_world";

    public VariousWorld(IEventBus bus, ModContainer container) {
        VWRegistryHelper.register(bus);
        VWBlocks.init();
        VWItems.init();
        VWEntities.init();
        ModConfigController.init();
        ConfiguredData.register();
        VWTags.init();
        VWMiscRegistries.register(bus);
        VWVillagers.register(bus);
        VWFeatures.register(bus);
        VWSounds.SOUND_EVENTS.register(bus);
    }

    public static Identifier createVWLocation(String path) {
        return Identifier.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static <T> void log(T message) {
        if (FMLLoader.getCurrent().isProduction()) {
            LOGGER.info(String.valueOf(message));
        }
    }
}

