/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.OnActionsTrigger;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.ArtifactTableMenu;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.init.VWBlocks;
import org.jetbrains.annotations.Nullable;

public class ArtifactTableBlockEntity
extends BaseContainerBlockEntity {
    public static final BlockCapability<IItemHandler, Void> TABLE_ITEM_HANDLER = BlockCapability.createVoid((Identifier)VariousWorld.createVWLocation("artifact_table_item_handler"), IItemHandler.class);
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            ArtifactTableBlockEntity.this.setChanged();
        }
    };
    public NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ArtifactTableBlockEntity.this.progress;
                case 1 -> ArtifactTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ArtifactTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ArtifactTableBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int tick = 0;
    public int progress = 0;
    private int maxProgress = 320;
    private ModConfigController.ArtifactSetting currentSetting;
    private String settingName = "";

    public ArtifactTableBlockEntity(BlockPos pos, BlockState state) {
        super(VWBlocks.ARTIFACT_TABLE_BE.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.various_world.artifact_table");
    }

    protected NonNullList<ItemStack> getItems() {
        if (this.items.isEmpty()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                this.items.set(i, (Object)this.itemHandler.getStackInSlot(i));
            }
        }
        return this.items;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.itemHandler.setStackInSlot(slot, stack);
        if (slot == 0 && ModConfigController.ARTIFACTS_CONFIG_VALUES != null) {
            for (ModConfigController.ArtifactSetting setting : ModConfigController.ARTIFACTS_CONFIG_VALUES) {
                if (this.currentSetting != null && !stack.getItem().equals(this.currentSetting.artifact().build())) {
                    this.currentSetting = setting;
                    break;
                }
                this.settingName = "";
                this.currentSetting = null;
            }
        }
    }

    public ItemStack removeItem(int slot, int amount) {
        this.itemHandler.extractItem(slot, amount, false);
        return super.removeItem(slot, amount);
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)nonNullList.get(i));
        }
        this.items = nonNullList;
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        this.itemHandler.serialize(valueOutput);
        valueOutput.putInt("table.progress", this.progress);
        valueOutput.putString("table.setting_name", this.settingName);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
        super.saveAdditional(valueOutput);
    }

    public void loadAdditional(ValueInput valueInput) {
        this.itemHandler.deserialize(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        for (int i = 0; i < this.items.size(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)this.items.get(i));
        }
        valueInput.getInt("table.progress").ifPresent(value -> {
            this.progress = value;
        });
        valueInput.getString("table.setting_name").ifPresent(value -> {
            this.settingName = value;
        });
        super.loadAdditional(valueInput);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.drops();
        super.preRemoveSideEffects(pos, state);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ArtifactTableMenu(i, inventory, (BlockEntity)this, this.data);
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new ArtifactTableMenu(i, inventory, (BlockEntity)this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos pos, BlockState state, ArtifactTableBlockEntity blockEntity) {
        ++this.tick;
        if (ModConfigController.ARTIFACTS_CONFIG_VALUES != null && this.tick % 20 == 0 && ((Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED)).booleanValue()) {
            for (ModConfigController.ArtifactSetting setting : ModConfigController.ARTIFACTS_CONFIG_VALUES) {
                if (this.currentSetting == null) {
                    if (setting.artifact().getId().getPath().equals(this.settingName)) {
                        this.currentSetting = setting;
                        break;
                    }
                    if (this.settingName.isEmpty() && this.itemHandler.getStackInSlot(0).getItem().equals(setting.artifact().build())) {
                        this.currentSetting = setting;
                    }
                }
                if (setting.artifact().build().equals(Items.AIR) || !this.itemHandler.getStackInSlot(0).getItem().equals(setting.artifact().build()) || this.progress > 0 || this.itemHandler.getStackInSlot(1).isEmpty() || this.itemHandler.getStackInSlot(2).isEmpty()) continue;
                this.progress = 320;
                OnActionsTrigger.spawnParticle((ParticleOptions)SpellParticleOption.create((ParticleType)ParticleTypes.EFFECT, (int)-929639936, (float)1.0f), level, pos.getX(), pos.getY(), pos.getZ(), 2.0f);
                level.playLocalSound(pos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.5f, 1.0f, true);
            }
            if (this.progress > 0 && this.itemHandler.getStackInSlot(2).is(Items.DRAGON_BREATH)) {
                --this.progress;
                OnActionsTrigger.spawnParticle((ParticleOptions)SpellParticleOption.create((ParticleType)ParticleTypes.EFFECT, (int)-929639936, (float)3.0f), level, pos.getX(), (float)pos.getY() + 0.5f, pos.getZ(), 2.0f);
                if (this.progress < 2) {
                    level.playLocalSound(pos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.5f, 1.0f, true);
                    blockEntity.removeItem(1, 1);
                    blockEntity.removeItem(2, 1);
                    this.progress = 0;
                    return;
                }
                int strength = this.currentSetting.effect_strength();
                int range = this.currentSetting.effect_range();
                List players = level.getEntitiesOfClass(Player.class, new AABB(pos.above().getCenter(), pos.above().getCenter()).inflate((double)(1 + range)));
                ItemStack potion = this.itemHandler.getStackInSlot(1);
                for (Player player : players) {
                    PotionContents potions;
                    if (!potion.has(DataComponents.POTION_CONTENTS) || !(potions = (PotionContents)potion.get(DataComponents.POTION_CONTENTS)).potion().isPresent() || player.hasEffect(((MobEffectInstance)((Potion)((Holder)potions.potion().get()).value()).getEffects().getFirst()).getEffect()) || level.isClientSide()) continue;
                    player.addEffect(new MobEffectInstance(((MobEffectInstance)((Potion)((Holder)potions.potion().get()).value()).getEffects().getFirst()).getEffect(), ((MobEffectInstance)((Potion)((Holder)potions.potion().get()).value()).getEffects().getFirst()).getDuration() / 2, this.adjustedAmplifier(((MobEffectInstance)((Potion)((Holder)potions.potion().get()).value()).getEffects().getFirst()).getAmplifier(), strength)));
                }
            }
        }
    }

    private int adjustedAmplifier(int baseAmplifier, int strength) {
        int raw = baseAmplifier + strength;
        return Math.max(0, raw);
    }

    public int getContainerSize() {
        return 3;
    }
}

