/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.DisassemblyTableMenu;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWItems;

public class DisassemblyTableBlockEntity
extends BaseContainerBlockEntity {
    public static final BlockCapability<IItemHandler, Void> TABLE_ITEM_HANDLER = BlockCapability.createVoid((Identifier)VariousWorld.createVWLocation("table_item_handler"), IItemHandler.class);
    public final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            DisassemblyTableBlockEntity.this.setChanged();
        }
    };
    public NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> DisassemblyTableBlockEntity.this.progress;
                case 1 -> DisassemblyTableBlockEntity.this.maxProgress;
                case 2 -> DisassemblyTableBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    DisassemblyTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    DisassemblyTableBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    DisassemblyTableBlockEntity.this.fuel = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };
    public int progress = 0;
    private int maxProgress = 60;
    private int fuel = 0;
    private int tick = 0;
    public int clientTick = 0;

    public DisassemblyTableBlockEntity(BlockPos pos, BlockState blockState) {
        super(VWBlocks.DISASSEMBLY_TABLE_BE.get(), pos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.various_world.disassembly_table");
    }

    protected NonNullList<ItemStack> getItems() {
        if (this.items.isEmpty()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                this.items.set(i, (Object)this.itemHandler.getStackInSlot(i));
            }
        }
        return this.items;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.itemHandler.extractItem(slot, amount, false);
        return super.removeItem(slot, amount);
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)nonNullList.get(i));
        }
        this.items = nonNullList;
    }

    protected void saveAdditional(ValueOutput output) {
        this.itemHandler.serialize(output);
        ContainerHelper.saveAllItems((ValueOutput)output, this.items);
        output.putInt("table.progress", this.progress);
        output.putInt("table.fuel", this.fuel);
        super.saveAdditional(output);
    }

    public void loadAdditional(ValueInput valueInput) {
        this.itemHandler.deserialize(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        valueInput.getInt("table.progress").ifPresent(value -> {
            this.progress = value;
        });
        valueInput.getInt("table.fuel").ifPresent(value -> {
            this.fuel = value;
        });
        super.loadAdditional(valueInput);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.drops();
        super.preRemoveSideEffects(pos, state);
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new DisassemblyTableMenu(i, inventory, (BlockEntity)this, this.data);
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new DisassemblyTableMenu(i, inventory, (BlockEntity)this, this.data);
    }

    public int getContainerSize() {
        return 4;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos pos, BlockState state, DisassemblyTableBlockEntity blockEntity) {
        if (!level.isClientSide()) {
            ++this.tick;
            if (this.tick % 20 == 0) {
                if (blockEntity.fuel <= 50 && blockEntity.getItem(0).is(VWItems.RECLAIMITE_SHARD)) {
                    blockEntity.removeItem(0, 1);
                    blockEntity.fuel += 10;
                }
                if (this.hasRecipe(level, blockEntity)) {
                    --blockEntity.fuel;
                    if (blockEntity.fuel > 0) {
                        ++blockEntity.progress;
                    } else if (blockEntity.progress > 0) {
                        --blockEntity.progress;
                    }
                    DisassemblyTableBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                    if (blockEntity.progress >= blockEntity.maxProgress) {
                        this.craftItem(level, blockEntity);
                    }
                } else {
                    blockEntity.resetProgress();
                    DisassemblyTableBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                }
            }
        } else {
            ++this.clientTick;
            if (this.hasRecipe(level, blockEntity) && this.clientTick % 20 == 0) {
                level.playLocalSound(pos, this.progress < 55 ? SoundEvents.WATER_AMBIENT : SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.4f, 0.4f, true);
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_ASH, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.8f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    private void craftItem(Level level, DisassemblyTableBlockEntity blockEntity) {
        ShapedRecipe recipe12;
        ItemStack inputStack = blockEntity.itemHandler.getStackInSlot(3);
        Recipe<?>[] recipes = this.getRecipesFor(inputStack, level);
        Recipe<?> recipe = Arrays.stream(recipes).filter(recipe1 -> recipe1.placementInfo().ingredients().size() > 1).findFirst().orElse(recipes[0]);
        if (recipe instanceof ShapedRecipe && this.isRecipeValid((Recipe<?>)(recipe12 = (ShapedRecipe)recipe))) {
            blockEntity.removeItem(3, 1);
            blockEntity.setItem(1, ((Item)((Ingredient)recipe12.placementInfo().ingredients().getFirst()).getValues().get(0).value()).getDefaultInstance());
            if (recipe.placementInfo().ingredients().size() > 1) {
                blockEntity.setItem(2, ((Item)((Ingredient)recipe12.placementInfo().ingredients().getLast()).getValues().get(0).value()).getDefaultInstance());
            }
        }
        if (recipe instanceof ShapelessRecipe && this.isRecipeValid((Recipe<?>)(recipe12 = (ShapelessRecipe)recipe))) {
            blockEntity.removeItem(3, 1);
            blockEntity.setItem(1, ((Item)((Ingredient)recipe12.placementInfo().ingredients().getFirst()).getValues().get(0).value()).getDefaultInstance());
            if (recipe.placementInfo().ingredients().size() > 1) {
                blockEntity.setItem(2, ((Item)((Ingredient)recipe12.placementInfo().ingredients().getLast()).getValues().get(0).value()).getDefaultInstance());
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
        }
        this.resetProgress();
    }

    private boolean isRecipeValid(Recipe<?> recipe) {
        return !recipe.placementInfo().ingredients().isEmpty() && (Optional.ofNullable((Ingredient)recipe.placementInfo().ingredients().getFirst()).isPresent() || Optional.ofNullable((Ingredient)recipe.placementInfo().ingredients().getLast()).isPresent());
    }

    public boolean hasRecipe(Level level, DisassemblyTableBlockEntity blockEntity) {
        return this.canInsertItemIntoOutputSlots() && !Arrays.stream(this.getRecipesFor(blockEntity.itemHandler.getStackInSlot(3), level)).toList().isEmpty();
    }

    private Recipe<?>[] getRecipesFor(ItemStack inputStack, Level level) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        if (inputStack.isEmpty() || !(level instanceof ServerLevel)) {
            return recipes.toArray(new Recipe[0]);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (RecipeHolder holder : serverLevel.recipeAccess().getRecipes()) {
            CraftingRecipe recipe;
            List ingredients;
            Recipe recipe2 = holder.value();
            if (!(recipe2 instanceof CraftingRecipe) || (ingredients = (recipe = (CraftingRecipe)recipe2).placementInfo().ingredients()).isEmpty()) continue;
            List<ItemStack> stacks = ingredients.stream().map(this::ingredientToRepresentativeStack).collect(Collectors.toList());
            this.ensureSizeNine(stacks);
            CraftingInput input = CraftingInput.of((int)3, (int)3, stacks);
            if (!DisassemblyTableBlockEntity.matches(inputStack, recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess()))) continue;
            recipes.add(recipe);
        }
        return recipes.toArray(new Recipe[0]);
    }

    private ItemStack ingredientToRepresentativeStack(Ingredient ing) {
        try {
            return ing.items().findFirst().map(stack -> ((Item)stack.value()).getDefaultInstance()).orElse(ItemStack.EMPTY);
        }
        catch (IllegalStateException e) {
            return ItemStack.EMPTY;
        }
    }

    private void ensureSizeNine(List<ItemStack> stacks) {
        while (stacks.size() < 9) {
            stacks.add(ItemStack.EMPTY);
        }
        if (stacks.size() > 9) {
            stacks.subList(9, stacks.size()).clear();
        }
    }

    private static boolean matches(ItemStack input, ItemStack output) {
        return input.is(output.getItem()) && input.getCount() >= output.getCount();
    }

    private boolean canInsertItemIntoOutputSlots() {
        return this.itemHandler.getStackInSlot(1).isEmpty() && this.itemHandler.getStackInSlot(2).isEmpty();
    }

    private void resetProgress() {
        this.progress = 0;
    }
}

