/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.ArtifactTableMenu;

public class ArtifactTableScreen
extends AbstractContainerScreen<ArtifactTableMenu> {
    private final Level level;
    private final Player player;
    public static final Identifier BACKGROUND_LOCATION = VariousWorld.createVWLocation("textures/gui/artifact_table.png");
    public static final Identifier TORCH = VariousWorld.createVWLocation("artifact_table_torch");
    public static final Identifier EFFECT_ICON = VariousWorld.createVWLocation("artifact_table_effect");

    public ArtifactTableScreen(ArtifactTableMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.level = inventory.player.level();
        this.player = inventory.player;
        this.imageWidth = 174;
        this.imageHeight = 164;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderIconsProgress(guiGraphics);
    }

    private void renderIconsProgress(GuiGraphics graphics) {
        if (((ArtifactTableMenu)this.getMenu()).isRefreshing()) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, EFFECT_ICON, 16, 32, 0, 0, this.leftPos + 80, this.topPos + 16, 16, ((ArtifactTableMenu)this.getMenu()).getScaledProgress());
        }
        if (((ArtifactTableMenu)this.getMenu()).isPowered()) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, TORCH, 16, 16, 0, 0, this.leftPos + 26, this.topPos + 48, 16, 16);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (Minecraft.getInstance().getLanguageManager().getSelected().equals("en_us")) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"block.various_world.artifact_table"), 56, 4, MapColor.COLOR_GRAY.col, false);
        }
    }
}

