/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.sashakyotoz.variousworld.common.OnActionsTrigger;
import net.sashakyotoz.variousworld.common.blocks.entities.recipes.GemsmithRecipeInput;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.common.items.data.CrystalData;
import net.sashakyotoz.variousworld.common.items.data.SupplyCrystalData;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;

public record GemsmithTransformRecipe(Ingredient tool, Ingredient gem, ItemStack result) implements Recipe<GemsmithRecipeInput>
{
    public boolean matches(GemsmithRecipeInput input, Level level) {
        return this.tool.test(input.tool()) && this.gem.test(input.gem());
    }

    public ItemStack assemble(GemsmithRecipeInput input, HolderLookup.Provider provider) {
        List<ModConfigController.GemsmithingSetting> setting = ModConfigController.CRYSTALING_CONFIG_VALUES;
        if (OnActionsTrigger.isInstanceOfAny(input.tool().getItem()) && setting != null) {
            ItemStack itemstack = input.tool().copy();
            ItemStack supplyGemStack = VWItems.SUPPLY_CRYSTAL.toStack();
            for (ModConfigController.GemsmithingSetting crystalingSetting : setting) {
                if (!input.gem().is(crystalingSetting.item().build())) continue;
                String toolName = OnActionsTrigger.getToolName(itemstack);
                supplyGemStack.set((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get(), (Object)new SupplyCrystalData(input.gem(), toolName));
                itemstack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(supplyGemStack, crystalingSetting.durability()));
            }
            return itemstack;
        }
        return input.tool();
    }

    public RecipeSerializer<? extends Recipe<GemsmithRecipeInput>> getSerializer() {
        return (RecipeSerializer)VWMiscRegistries.GEMSMITH_TRANSFORM.get();
    }

    public RecipeType<? extends Recipe<GemsmithRecipeInput>> getType() {
        return (RecipeType)VWMiscRegistries.GEMSMITH_TRANSFORM_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create(List.of(this.tool, this.gem));
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.SMITHING;
    }

    public static class Serializer
    implements RecipeSerializer<GemsmithTransformRecipe> {
        private static final MapCodec<GemsmithTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("tool").forGetter(GemsmithTransformRecipe::tool), (App)Ingredient.CODEC.fieldOf("gem").forGetter(GemsmithTransformRecipe::gem), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(GemsmithTransformRecipe::result)).apply((Applicative)instance, GemsmithTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GemsmithTransformRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, GemsmithTransformRecipe::tool, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, GemsmithTransformRecipe::gem, (StreamCodec)ItemStack.STREAM_CODEC, GemsmithTransformRecipe::result, GemsmithTransformRecipe::new);

        public MapCodec<GemsmithTransformRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GemsmithTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

