/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.entities.brain.behavior;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.variousworld.common.entities.SquealingSpiderEntity;

public class LongLeaping
extends Behavior<SquealingSpiderEntity> {
    private static final int INHALING_DURATION_TICKS = Math.round(10.0f);
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongLeaping() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_SHOOT, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.REGISTERED), 200);
    }

    public static boolean canRun(ServerLevel level, SquealingSpiderEntity spider) {
        if (!spider.onGround() && !spider.isInWater()) {
            return false;
        }
        if (Swim.shouldSwim((Mob)spider)) {
            return false;
        }
        if (spider.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.VALUE_PRESENT)) {
            return true;
        }
        LivingEntity livingentity = spider.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (livingentity == null) {
            return false;
        }
        if (LongLeaping.outOfAggroRange(spider, livingentity)) {
            spider.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            return false;
        }
        if (LongLeaping.tooCloseForJump(spider, livingentity)) {
            return false;
        }
        if (!LongLeaping.canJumpFromCurrentPosition(level, spider)) {
            return false;
        }
        BlockPos blockpos = LongLeaping.snapToSurface((LivingEntity)spider, LongLeaping.randomPointBehindTarget(livingentity, spider.getRandom()));
        if (blockpos == null) {
            return false;
        }
        BlockState blockstate = level.getBlockState(blockpos.below());
        if (spider.getType().isBlockDangerous(blockstate)) {
            return false;
        }
        if (!LongLeaping.hasLineOfSight(spider, blockpos.getCenter()) && !LongLeaping.hasLineOfSight(spider, blockpos.above(4).getCenter())) {
            return false;
        }
        spider.getBrain().setMemory(MemoryModuleType.BREEZE_JUMP_TARGET, (Object)blockpos);
        return true;
    }

    static Vec3 randomPointBehindTarget(LivingEntity target, RandomSource random) {
        float f = target.yHeadRot + 180.0f + (float)random.nextGaussian() * 90.0f / 2.0f;
        float f1 = Mth.lerp((float)random.nextFloat(), (float)4.0f, (float)8.0f);
        Vec3 vec3 = Vec3.directionFromRotation((float)0.0f, (float)f).scale((double)f1);
        return target.position().add(vec3);
    }

    static boolean hasLineOfSight(SquealingSpiderEntity spider, Vec3 pos) {
        Vec3 vec3 = new Vec3(spider.getX(), spider.getY(), spider.getZ());
        return !(pos.distanceTo(vec3) > 50.0) && spider.level().clip(new ClipContext(vec3, pos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)spider)).getType() == HitResult.Type.MISS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, SquealingSpiderEntity owner) {
        return LongLeaping.canRun(level, owner);
    }

    protected boolean canStillUse(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        return entity.getPose() != Pose.STANDING && !entity.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_JUMP_COOLDOWN);
    }

    protected void start(ServerLevel level, SquealingSpiderEntity entity, long gameTime) {
        if (entity.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.VALUE_ABSENT)) {
            entity.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_INHALING, (Object)Unit.INSTANCE, (long)INHALING_DURATION_TICKS);
        }
        entity.setPose(Pose.INHALING);
        level.playSound(null, (Entity)entity, SoundEvents.BREEZE_CHARGE, SoundSource.HOSTILE, 1.0f, 1.0f);
        entity.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).ifPresent(p_312818_ -> entity.lookAt(EntityAnchorArgument.Anchor.EYES, p_312818_.getCenter()));
    }

    protected void tick(ServerLevel level, SquealingSpiderEntity owner, long gameTime) {
        boolean flag = owner.isInWater();
        if (!flag && owner.getBrain().checkMemory(MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.VALUE_PRESENT)) {
            owner.getBrain().eraseMemory(MemoryModuleType.BREEZE_LEAVING_WATER);
        }
        if (LongLeaping.isFinishedInhaling(owner)) {
            Vec3 vec3 = owner.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).flatMap(target -> LongLeaping.calculateOptimalJumpVector(owner, owner.getRandom(), Vec3.atBottomCenterOf((Vec3i)target))).orElse(null);
            if (vec3 == null) {
                owner.setPose(Pose.STANDING);
                return;
            }
            if (flag) {
                owner.getBrain().setMemory(MemoryModuleType.BREEZE_LEAVING_WATER, (Object)Unit.INSTANCE);
            }
            owner.playSound(SoundEvents.BREEZE_JUMP, 1.0f, 1.0f);
            owner.setPose(Pose.LONG_JUMPING);
            owner.setYRot(owner.yBodyRot);
            owner.setDiscardFriction(true);
            owner.setDeltaMovement(vec3);
        } else if (LongLeaping.isFinishedJumping(owner)) {
            owner.playSound(SoundEvents.BREEZE_LAND, 1.0f, 1.0f);
            owner.setPose(Pose.STANDING);
            owner.setDiscardFriction(false);
            boolean flag1 = owner.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
            owner.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_COOLDOWN, (Object)Unit.INSTANCE, flag1 ? 2L : 10L);
            owner.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, (Object)Unit.INSTANCE, 100L);
        }
    }

    protected void stop(ServerLevel level, SquealingSpiderEntity spider, long gameTime) {
        if (spider.getPose() == Pose.LONG_JUMPING || spider.getPose() == Pose.INHALING) {
            spider.setPose(Pose.STANDING);
        }
        spider.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_TARGET);
        spider.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_INHALING);
        spider.getBrain().eraseMemory(MemoryModuleType.BREEZE_LEAVING_WATER);
    }

    private static boolean isFinishedInhaling(SquealingSpiderEntity breeze) {
        return breeze.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_INHALING).isEmpty() && breeze.getPose() == Pose.INHALING;
    }

    private static boolean isFinishedJumping(SquealingSpiderEntity breeze) {
        boolean flag = breeze.getPose() == Pose.LONG_JUMPING;
        boolean flag1 = breeze.onGround();
        boolean flag2 = breeze.isInWater() && breeze.getBrain().checkMemory(MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.VALUE_ABSENT);
        return flag && (flag1 || flag2);
    }

    @Nullable
    public static BlockPos snapToSurface(LivingEntity owner, Vec3 targetPos) {
        ClipContext clipcontext = new ClipContext(targetPos, targetPos.relative(Direction.DOWN, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner);
        BlockHitResult hitresult = owner.level().clip(clipcontext);
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            return BlockPos.containing((Position)hitresult.getLocation()).above();
        }
        ClipContext clipcontext1 = new ClipContext(targetPos, targetPos.relative(Direction.UP, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner);
        BlockHitResult hitresult1 = owner.level().clip(clipcontext1);
        return hitresult1.getType() == HitResult.Type.BLOCK ? BlockPos.containing((Position)hitresult1.getLocation()).above() : null;
    }

    private static boolean outOfAggroRange(SquealingSpiderEntity spider, LivingEntity target) {
        return !target.closerThan((Entity)spider, 24.0);
    }

    private static boolean tooCloseForJump(SquealingSpiderEntity spider, LivingEntity target) {
        return target.distanceTo((Entity)spider) - 4.0f <= 0.0f;
    }

    private static boolean canJumpFromCurrentPosition(ServerLevel level, SquealingSpiderEntity spider) {
        BlockPos blockpos = spider.blockPosition();
        for (int i = 1; i <= 4; ++i) {
            BlockPos blockpos1 = blockpos.relative(Direction.UP, i);
            if (level.getBlockState(blockpos1).isAir() || level.getFluidState(blockpos1).is(FluidTags.WATER)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3> calculateOptimalJumpVector(SquealingSpiderEntity spider, RandomSource random, Vec3 target) {
        Iterator iterator = Util.shuffledCopy(ALLOWED_ANGLES, (RandomSource)random).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional optional = LongJumpUtil.calculateJumpVectorForAngle((Mob)spider, (Vec3)target, (float)1.4f, (int)i, (boolean)false);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }
}

