/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.world.features.trees.ExtraBranchedTrunkPlacer;
import net.sashakyotoz.variousworld.common.world.features.trees.FancyHangingFoliagePlacer;
import net.sashakyotoz.variousworld.init.VWBlocks;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRYSTALIC_TREE = ModConfiguredFeatures.registerKey("crystalic_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_CRYSTALIC_TREE = ModConfiguredFeatures.registerKey("small_crystalic_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_JACARANDA_TREE = ModConfiguredFeatures.registerKey("blue_jacaranda_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JACARANDA_PETALS_PATCH = ModConfiguredFeatures.registerKey("jacaranda_petals_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SODALITE_WART_PATCH = ModConfiguredFeatures.registerKey("sodalite_wart_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SODALITE_GEODE = ModConfiguredFeatures.registerKey("sodalite_geode");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.NETHERRACK);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.END_STONE);
        ModConfiguredFeatures.register(context, CRYSTALIC_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.CRYSTALIC_OAK_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(4, 3, 3), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.CRYSTALIC_OAK_LEAVES.get())), (FoliagePlacer)new FancyHangingFoliagePlacer((IntProvider)UniformInt.of((int)2, (int)4), (IntProvider)UniformInt.of((int)0, (int)1), (IntProvider)UniformInt.of((int)4, (int)6), 0.25f), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(2))).build());
        ModConfiguredFeatures.register(context, SMALL_CRYSTALIC_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.CRYSTALIC_OAK_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(2, 3, 4), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.CRYSTALIC_OAK_LEAVES.get())), (FoliagePlacer)new FancyHangingFoliagePlacer((IntProvider)UniformInt.of((int)2, (int)4), (IntProvider)UniformInt.of((int)0, (int)1), (IntProvider)UniformInt.of((int)4, (int)5), 0.25f), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(2))).build());
        ModConfiguredFeatures.register(context, BLUE_JACARANDA_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.BLUE_JACARANDA_LOG.get())), (TrunkPlacer)new ExtraBranchedTrunkPlacer(6, 4, 3), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.BLUE_JACARANDA_LEAVES.get())), (FoliagePlacer)new FancyHangingFoliagePlacer((IntProvider)UniformInt.of((int)2, (int)4), (IntProvider)UniformInt.of((int)0, (int)1), (IntProvider)UniformInt.of((int)4, (int)6), 0.25f), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(2))).build());
        ModConfiguredFeatures.register(context, SODALITE_WART_PATCH, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.SODALITE_WART.get())))));
        ModConfiguredFeatures.register(context, SODALITE_GEODE, Feature.GEODE, new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.SODALITE_BLOCK.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)VWBlocks.BUDDING_SODALITE.get())), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CALCITE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.TUFF), List.of(((AmethystClusterBlock)VWBlocks.SMALL_SODALITE_BUD.get()).defaultBlockState(), ((AmethystClusterBlock)VWBlocks.MEDIUM_SODALITE_BUD.get()).defaultBlockState(), ((AmethystClusterBlock)VWBlocks.MEDIUM_SODALITE_BUD.get()).defaultBlockState(), ((AmethystClusterBlock)VWBlocks.SODALITE_CLUSTER.get()).defaultBlockState()), BlockTags.FEATURES_CANNOT_REPLACE, BlockTags.GEODE_INVALID_BLOCKS), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.35, 0.075, true, (IntProvider)UniformInt.of((int)4, (int)6), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)UniformInt.of((int)1, (int)2), -16, 16, 0.05, 1));
        WeightedList.Builder builder = WeightedList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)((FlowerBedBlock)VWBlocks.BLUE_JACARANDA_PETALS.get()).defaultBlockState().setValue((Property)FlowerBedBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)FlowerBedBlock.FACING, (Comparable)direction)), 1);
            }
        }
        ModConfiguredFeatures.register(context, JACARANDA_PETALS_PATCH, Feature.FLOWER, new RandomPatchConfiguration(72, 5, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)))));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (Identifier)VariousWorld.createVWLocation(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

