/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.world.features.ModConfiguredFeatures;
import net.sashakyotoz.variousworld.init.VWBlocks;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> CRYSTALIC_TREE = ModPlacedFeatures.registerKey("crystalic_tree");
    public static final ResourceKey<PlacedFeature> SMALL_CRYSTALIC_TREE = ModPlacedFeatures.registerKey("small_crystalic_tree");
    public static final ResourceKey<PlacedFeature> BLUE_JACARANDA_TREE = ModPlacedFeatures.registerKey("blue_jacaranda_tree");
    public static final ResourceKey<PlacedFeature> JACARANDA_PETALS_PATCH = ModPlacedFeatures.registerKey("jacaranda_petals_patch");
    public static final ResourceKey<PlacedFeature> SODALITE_WART_PATCH = ModPlacedFeatures.registerKey("sodalite_wart_patch");
    public static final ResourceKey<PlacedFeature> SODALITE_GEODE = ModPlacedFeatures.registerKey("sodalite_geode");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, CRYSTALIC_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.CRYSTALIC_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.25f, (int)2), (Block)((Block)VWBlocks.CRYSTALIC_OAK_SAPLING.get())));
        ModPlacedFeatures.register(context, SMALL_CRYSTALIC_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.CRYSTALIC_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.125f, (int)2), (Block)((Block)VWBlocks.CRYSTALIC_OAK_SAPLING.get())));
        ModPlacedFeatures.register(context, BLUE_JACARANDA_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.BLUE_JACARANDA_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.25f, (int)2), (Block)((Block)VWBlocks.BLUE_JACARANDA_SAPLING.get())));
        ModPlacedFeatures.register(context, SODALITE_WART_PATCH, configuredFeatures.getOrThrow(ModConfiguredFeatures.SODALITE_WART_PATCH), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, JACARANDA_PETALS_PATCH, configuredFeatures.getOrThrow(ModConfiguredFeatures.JACARANDA_PETALS_PATCH), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, SODALITE_GEODE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SODALITE_GEODE), List.of(RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)12), (VerticalAnchor)VerticalAnchor.absolute((int)48)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (Identifier)VariousWorld.createVWLocation(name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

