/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class BlocksChainFeature
extends Feature<BlockStateConfiguration> {
    public BlocksChainFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int maxSearchDistance;
        BlockState chainState = ((BlockStateConfiguration)context.config()).state;
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        if (this.tryPlaceAlongAxis(level, origin, chainState, Direction.Axis.X, maxSearchDistance = 12 + random.nextInt(13), random)) {
            return true;
        }
        return this.tryPlaceAlongAxis(level, origin, chainState, Direction.Axis.Z, maxSearchDistance, random);
    }

    private boolean tryPlaceAlongAxis(WorldGenLevel level, BlockPos origin, BlockState chainState, Direction.Axis axis, int maxSearchDistance, RandomSource random) {
        BlockPos end;
        int coordPos;
        Direction negative = axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH;
        Direction positive = axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        BlockPos wallNeg = this.findFirstNonEmpty(level, origin, negative, maxSearchDistance);
        BlockPos wallPos = this.findFirstNonEmpty(level, origin, positive, maxSearchDistance);
        if (wallNeg == null || wallPos == null) {
            return false;
        }
        int coordNeg = axis == Direction.Axis.X ? wallNeg.getX() : wallNeg.getZ();
        int n = coordPos = axis == Direction.Axis.X ? wallPos.getX() : wallPos.getZ();
        if (Math.abs(coordPos - coordNeg) <= 1) {
            return false;
        }
        int startCoord = Math.min(coordNeg, coordPos) + 1;
        int endCoord = Math.max(coordNeg, coordPos) - 1;
        int y = origin.getY();
        BlockPos start = axis == Direction.Axis.X ? new BlockPos(startCoord, y, origin.getZ()) : new BlockPos(origin.getX(), y, startCoord);
        BlockPos blockPos = end = axis == Direction.Axis.X ? new BlockPos(endCoord, y, origin.getZ()) : new BlockPos(origin.getX(), y, endCoord);
        if (!this.rectangularGapIsEmpty(level, start, end)) {
            return false;
        }
        int samples = Math.max((int)Math.ceil(start.distSqr((Vec3i)end) * 0.5), 12);
        samples = Math.min(samples, 256);
        for (int attempt = 0; attempt < 3; ++attempt) {
            double sideOffset = BlocksChainFeature.computeSideOffset(start, end, random);
            double sag = BlocksChainFeature.computeSag(start, end, random);
            List<BlockPos> curvePositions = this.generateCurvePositions(start, end, axis, sideOffset, sag, samples, random);
            int currSamples = samples;
            while (!this.isFaceConnectedSequence(curvePositions) && currSamples <= 1024 && (currSamples *= 2) <= 1024) {
                curvePositions = this.generateCurvePositions(start, end, axis, sideOffset, sag, currSamples, random);
            }
            if (this.isFaceConnectedSequence(curvePositions)) {
                boolean allEmpty = true;
                for (BlockPos p : curvePositions) {
                    if (level.isEmptyBlock(p)) continue;
                    allEmpty = false;
                    break;
                }
                if (allEmpty) {
                    for (BlockPos p : curvePositions) {
                        level.setBlock(p, chainState, 2);
                    }
                    return true;
                }
            }
            samples = Math.min(samples * 2, 512);
        }
        return false;
    }

    private static double computeSideOffset(BlockPos a, BlockPos b, RandomSource random) {
        double dx = b.getX() - a.getX();
        double dz = b.getZ() - a.getZ();
        double horizontal = Math.sqrt(dx * dx + dz * dz);
        double base = Math.max(1.0, horizontal) * (0.15 + random.nextDouble() * 0.45);
        return (double)(random.nextBoolean() ? 1 : -1) * base;
    }

    private static double computeSag(BlockPos a, BlockPos b, RandomSource random) {
        double dx = b.getX() - a.getX();
        double dz = b.getZ() - a.getZ();
        double horizontal = Math.sqrt(dx * dx + dz * dz);
        double sag = horizontal * (0.05 + random.nextDouble() * 0.2);
        return -sag;
    }

    private List<BlockPos> generateCurvePositions(BlockPos start, BlockPos end, Direction.Axis axis, double sideOffset, double sag, int samples, RandomSource random) {
        double mx = (double)(start.getX() + end.getX()) * 0.5;
        double my = (double)(start.getY() + end.getY()) * 0.5;
        double mz = (double)(start.getZ() + end.getZ()) * 0.5;
        double cx = mx;
        double cy = my + sag;
        double cz = mz;
        if (axis == Direction.Axis.X) {
            cz += sideOffset;
        } else {
            cx += sideOffset;
        }
        LinkedHashSet<BlockPos> ordered = new LinkedHashSet<BlockPos>();
        for (int i = 0; i <= samples; ++i) {
            double t = (double)i / (double)samples;
            double omt = 1.0 - t;
            double bx = omt * omt * (double)start.getX() + 2.0 * omt * t * cx + t * t * (double)end.getX();
            double by = omt * omt * (double)start.getY() + 2.0 * omt * t * cy + t * t * (double)end.getY();
            double bz = omt * omt * (double)start.getZ() + 2.0 * omt * t * cz + t * t * (double)end.getZ();
            int ix = (int)Math.round(bx);
            int iy = (int)Math.round(by);
            int iz = (int)Math.round(bz);
            ordered.add(new BlockPos(ix, iy, iz));
        }
        return new ArrayList<BlockPos>(ordered);
    }

    private boolean rectangularGapIsEmpty(WorldGenLevel level, BlockPos a, BlockPos b) {
        int minX = Math.min(a.getX(), b.getX());
        int maxX = Math.max(a.getX(), b.getX());
        int minZ = Math.min(a.getZ(), b.getZ());
        int maxZ = Math.max(a.getZ(), b.getZ());
        int y = a.getY();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (level.isEmptyBlock(new BlockPos(x, y, z))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFaceConnectedSequence(List<BlockPos> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int i = 1; i < list.size(); ++i) {
            if (this.areFaceAdjacent(list.get(i - 1), list.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areFaceAdjacent(BlockPos a, BlockPos b) {
        int dz;
        int dy;
        int dx = Math.abs(a.getX() - b.getX());
        return dx + (dy = Math.abs(a.getY() - b.getY())) + (dz = Math.abs(a.getZ() - b.getZ())) == 1;
    }

    private BlockPos findFirstNonEmpty(WorldGenLevel level, BlockPos start, Direction dir, int maxDist) {
        for (int i = 1; i <= maxDist; ++i) {
            BlockPos p = start.relative(dir, i);
            if (level.isEmptyBlock(p)) continue;
            return p;
        }
        return null;
    }
}

