/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWItems;

public class VWRegistryHelper {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"various_world");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"various_world");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"various_world");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"various_world");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"various_world");
    public static Map<TagKey<Block>, List<Supplier<Block>>> BLOCK_TAGS = new HashMap<TagKey<Block>, List<Supplier<Block>>>();
    public static Map<DeferredBlock<?>, ItemLike> BLOCK_DROPS = new HashMap();
    public static Map<Block, ItemLike> BLOCK_SILK_DROPS = new HashMap<Block, ItemLike>();
    public static Map<DeferredBlock<?>, Block> BLOCK_STRIPPED = new HashMap();
    public static Map<DeferredBlock<?>, Map<Models, DeferredBlock<?>>> BLOCK_SETS = new HashMap();
    public static Map<Models, List<DeferredBlock<?>>> BLOCK_MODELS = new HashMap();
    public static List<DeferredBlock<?>> BLOCK_CUTOUT = new ArrayList();
    public static List<DeferredBlock<?>> BLOCK_TRANSLUCENT = new ArrayList();
    public static Map<DeferredBlock<?>, Pair<Integer, Integer>> BLOCK_FLAMMABLE = new HashMap();
    public static Map<TagKey<Item>, List<Item>> ITEM_TAGS = new HashMap<TagKey<Item>, List<Item>>();
    public static Map<DeferredItem<?>, ModelTemplate> ITEM_MODELS = new HashMap();
    public static Map<ItemLike, Integer> ITEM_BURNABLE = new HashMap<ItemLike, Integer>();
    public static Map<TagKey<EntityType<?>>, List<DeferredHolder<EntityType<?>, ?>>> ENTITY_TAGS = new HashMap();
    public static Map<DeferredHolder<EntityType<?>, ?>, ItemLike> ENTITY_DROPS = new HashMap();
    public static final DeferredHolder<CreativeModeTab, ?> VARIOUS_WORLD_TAB = CREATIVE_MODE_TABS.register("various_world_tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack(VWBlocks.BLUE_JACARANDA_SAPLING)).title((Component)Component.translatable((String)"creativetab.various_world_tab")).displayItems((pParameters, tabData) -> {
        BLOCKS.getEntries().forEach(block -> {
            if (!block.getRegisteredName().contains("pot")) {
                tabData.accept((ItemLike)((Block)block.get()).asItem());
            }
        });
        ITEMS.getEntries().forEach(item -> {
            if (!(item.is(VWItems.SUPPLY_CRYSTAL.getId()) || item.getRegisteredName().contains("sign") || item.getRegisteredName().contains("pot"))) {
                tabData.accept((ItemLike)((Item)item.get()).asItem());
            }
        });
    }).build());

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
        BLOCK_ENTITIES.register(bus);
        ENTITIES.register(bus);
        CREATIVE_MODE_TABS.register(bus);
    }

    public static <T extends Block> BlockBuilder<T> ofBlock(String id, Function<Identifier, T> block) {
        return VWRegistryHelper.ofBlock(id, block, true);
    }

    public static <T extends Block> BlockBuilder<T> ofBlock(String id, Function<Identifier, T> block, boolean doubleBlock, boolean item) {
        return new BlockBuilder<T>(id, block, doubleBlock, item);
    }

    public static <T extends Block> BlockBuilder<T> ofBlock(String id, Function<Identifier, T> block, boolean item) {
        return new BlockBuilder<T>(id, block, false, item);
    }

    public static <T extends Item> ItemBuilder<T> ofItem(String id, Function<Item.Properties, T> item) {
        return new ItemBuilder<T>(id, item);
    }

    public static <T extends Block> DeferredBlock<T> registerBlock(String name, Function<Identifier, T> block, boolean registerItem) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        if (registerItem) {
            VWRegistryHelper.registerBlockItem(name, toReturn);
        }
        return toReturn;
    }

    public static <T extends Block> DeferredBlock<T> registerDoubleBlock(String name, Function<Identifier, T> block, boolean registerItem) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        if (registerItem) {
            VWRegistryHelper.registerDoubleBlockItem(name, toReturn);
        }
        return toReturn;
    }

    private static <T extends Block> DeferredItem<BlockItem> registerBlockItem(String name, DeferredBlock<T> block) {
        return ITEMS.registerSimpleBlockItem(name, block);
    }

    private static <T extends Block> DeferredItem<Item> registerDoubleBlockItem(String name, DeferredBlock<T> block) {
        return ITEMS.register(name, key -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)key)).useBlockDescriptionPrefix()));
    }

    public static List<DeferredBlock<?>> getModelList(Models key) {
        return BLOCK_MODELS.getOrDefault((Object)key, new ArrayList());
    }

    public static void registerStairsAndSlab(DeferredBlock<?> parent, DeferredBlock<?> stairs, DeferredBlock<?> slab) {
        VWRegistryHelper.registerSet(parent, Map.of(Models.STAIRS, stairs, Models.SLAB, slab));
    }

    public static void registerGlass(DeferredBlock<?> parent, DeferredBlock<?> pane) {
        VWRegistryHelper.registerSet(parent, Map.of(Models.PANE, pane));
    }

    public static void registerSet(DeferredBlock<?> parent, Map<Models, DeferredBlock<?>> set) {
        BLOCK_SETS.putIfAbsent(parent, set);
        for (Models model : set.keySet()) {
            BLOCK_MODELS.putIfAbsent(model, new ArrayList());
            BLOCK_MODELS.get((Object)model).add(set.get((Object)model));
        }
    }

    public static void addDrop(DeferredBlock<?> block, ItemLike loot) {
        BLOCK_DROPS.putIfAbsent(block, loot);
    }

    public static <T extends Entity> EntityBuilder ofEntity(String id, EntityType.Builder<T> tBuilder) {
        return new EntityBuilder<T>(id, tBuilder);
    }

    public static class BlockBuilder<T extends Block> {
        public String name;
        public DeferredBlock<?> block;

        public BlockBuilder(String name, Function<Identifier, T> block, boolean doubleBlock, boolean item) {
            this.name = name;
            this.block = doubleBlock ? VWRegistryHelper.registerDoubleBlock(name, block, item) : VWRegistryHelper.registerBlock(name, block, item);
        }

        public DeferredBlock build() {
            return this.block;
        }

        public BlockBuilder drop() {
            return this.drop((ItemLike)this.block);
        }

        public BlockBuilder drop(ItemLike loot) {
            BLOCK_DROPS.putIfAbsent(this.block, loot);
            return this;
        }

        public BlockBuilder tag(TagKey<Block> tagname) {
            BLOCK_TAGS.putIfAbsent(tagname, new ArrayList());
            BLOCK_TAGS.get(tagname).add(() -> (Block)this.block.get());
            return this;
        }

        @SafeVarargs
        public final BlockBuilder tag(TagKey<Block> ... tags) {
            for (TagKey<Block> tagname : tags) {
                this.tag(tagname);
            }
            return this;
        }

        public BlockBuilder tagitem(TagKey<Item> tagname) {
            ITEM_TAGS.putIfAbsent(tagname, new ArrayList());
            ITEM_TAGS.get(tagname).add(((Block)this.block.get()).asItem());
            return this;
        }

        @SafeVarargs
        public final BlockBuilder tagitem(TagKey<Item> ... tags) {
            for (TagKey<Item> tagname : tags) {
                this.tagitem(tagname);
            }
            return this;
        }

        public BlockBuilder tool(String tool_material) {
            String[] needed = tool_material.split("_");
            if (needed[0].equals("stone")) {
                this.tag((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL);
            }
            if (needed[0].equals("iron")) {
                this.tag((TagKey<Block>)BlockTags.NEEDS_IRON_TOOL);
            }
            if (needed[0].equals("diamond")) {
                this.tag((TagKey<Block>)BlockTags.NEEDS_DIAMOND_TOOL);
            }
            if (needed[1].equals("pickaxe")) {
                this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE);
            }
            if (needed[1].equals("axe")) {
                this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE);
            }
            if (needed[1].equals("shovel")) {
                this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL);
            }
            if (needed[1].equals("hoe")) {
                this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);
            }
            if (needed[1].equals("sword")) {
                this.tag((TagKey<Block>)BlockTags.SWORD_EFFICIENT);
            }
            return this;
        }

        public BlockBuilder model() {
            return this.model(Models.CUBE);
        }

        public BlockBuilder model(Models model) {
            BLOCK_MODELS.putIfAbsent(model, new ArrayList());
            BLOCK_MODELS.get((Object)model).add(this.block);
            return this;
        }

        public BlockBuilder cutout() {
            BLOCK_CUTOUT.add(this.block);
            return this;
        }

        public BlockBuilder translucent() {
            BLOCK_TRANSLUCENT.add(this.block);
            return this;
        }

        public BlockBuilder fuel(int duration) {
            ITEM_BURNABLE.put((ItemLike)this.block, duration);
            return this;
        }

        public BlockBuilder flammable(int duration, int spread) {
            BLOCK_FLAMMABLE.put(this.block, (Pair<Integer, Integer>)new Pair((Object)duration, (Object)spread));
            return this;
        }

        public BlockBuilder strip(Block stripped) {
            BLOCK_STRIPPED.putIfAbsent(this.block, stripped);
            return this;
        }
    }

    public static class ItemBuilder<T extends Item> {
        protected String name;
        protected DeferredItem<?> item;

        protected ItemBuilder(String name, Function<Item.Properties, T> item) {
            this.name = name;
            this.item = ITEMS.registerItem(name, item);
        }

        public DeferredItem build() {
            return this.item;
        }

        public ItemBuilder tag(TagKey<Item> tagname) {
            ITEM_TAGS.putIfAbsent(tagname, new ArrayList());
            ITEM_TAGS.get(tagname).add((Item)this.item.get());
            return this;
        }

        @SafeVarargs
        public final ItemBuilder tag(TagKey<Item> ... tags) {
            for (TagKey<Item> tagname : tags) {
                this.tag(tagname);
            }
            return this;
        }

        public ItemBuilder model() {
            return this.model(ModelTemplates.FLAT_ITEM);
        }

        public ItemBuilder model(ModelTemplate model) {
            ITEM_MODELS.put(this.item, model);
            return this;
        }

        public ItemBuilder fuel(int duration) {
            ITEM_BURNABLE.put((ItemLike)this.item, duration);
            return this;
        }
    }

    public static enum Models {
        CUBE,
        CROSS,
        DIRECTIONAL_CROSS,
        PILLAR,
        WOOD,
        STAIRS,
        SLAB,
        BUTTON,
        PRESSURE_PLATE,
        FENCE,
        FENCE_GATE,
        DOOR,
        TRAPDOOR,
        WALL,
        SIGN,
        WALL_SIGN,
        HANGING_SIGN,
        WALL_HANGING_SIGN,
        PANE,
        GRASS,
        CROSS_POTTED,
        ROTATABLE;

    }

    public static class EntityBuilder<T extends Entity> {
        protected final String name;
        protected final DeferredHolder<EntityType<?>, EntityType<T>> entity;

        protected EntityBuilder(String name, EntityType.Builder<T> entityBuilder) {
            this.name = name;
            this.entity = EntityBuilder.register(name, entityBuilder);
        }

        public DeferredHolder<EntityType<?>, EntityType<T>> build() {
            return this.entity;
        }

        private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryName, EntityType.Builder<T> entityTypeBuilder) {
            return ENTITIES.register(registryName, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)VariousWorld.createVWLocation(registryName))));
        }

        public EntityBuilder<T> drop(ItemLike loot) {
            ENTITY_DROPS.putIfAbsent(this.entity, loot);
            return this;
        }

        public EntityBuilder<T> tag(TagKey<EntityType<?>> tagName) {
            ENTITY_TAGS.putIfAbsent(tagName, new ArrayList());
            ENTITY_TAGS.get(tagName).add(this.entity);
            return this;
        }

        @SafeVarargs
        public final EntityBuilder<T> tag(TagKey<EntityType<?>> ... tagName) {
            for (TagKey<EntityType<?>> tag : tagName) {
                ENTITY_TAGS.putIfAbsent(tag, new ArrayList());
                ENTITY_TAGS.get(tag).add(this.entity);
            }
            return this;
        }
    }
}

