/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.mixin;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.sashakyotoz.variousworld.common.config.ConfiguredData;
import net.sashakyotoz.variousworld.common.config.ConfiguredDataResourcePack;
import net.sashakyotoz.variousworld.common.config.IResourceExistence;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPackResourceManager.class})
public class MultiPackResourceManagerMixin
implements IResourceExistence {
    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(PackType type, List packs, CallbackInfo ci) {
        ConfiguredData.MANAGER_KEEPER.put(0, (MultiPackResourceManager)this);
    }

    @Unique
    private static Resource readAndApply(Optional<Resource> resource, ConfiguredData data) {
        String result = "";
        if (resource.isEmpty()) {
            result = data.apply(null);
        } else {
            try {
                result = data.apply(new String(resource.get().open().readAllBytes()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String finalResult = result;
        return new Resource((PackResources)ConfiguredDataResourcePack.INSTANCE, () -> new CharSequenceInputStream((CharSequence)finalResult, Charset.defaultCharset()));
    }

    @Unique
    private static Resource readAndApply(Resource resource, ConfiguredData data) {
        if (resource.source() instanceof ConfiguredDataResourcePack) {
            return resource;
        }
        return MultiPackResourceManagerMixin.readAndApply(Optional.of(resource), data);
    }

    @Inject(method={"getResource"}, at={@At(value="RETURN")}, cancellable=true)
    public void getConfiguredResource(Identifier id, CallbackInfoReturnable<Optional<Resource>> cir) {
        ConfiguredData data = ConfiguredData.get(id);
        if (data == null || !data.enabled.get().booleanValue() || ((Optional)cir.getReturnValue()).isPresent() && ((Resource)((Optional)cir.getReturnValue()).get()).source() instanceof ConfiguredDataResourcePack) {
            return;
        }
        cir.setReturnValue(Optional.of(MultiPackResourceManagerMixin.readAndApply((Optional)cir.getReturnValue(), data)));
    }

    @Inject(method={"getResourceStack"}, at={@At(value="RETURN")}, cancellable=true)
    public void getAllConfiguredResource(Identifier id, CallbackInfoReturnable<List<Resource>> cir) {
        ConfiguredData data = ConfiguredData.get(id);
        if (data == null || !data.enabled.get().booleanValue()) {
            return;
        }
        List<Resource> result = ((List)cir.getReturnValue()).stream().map(resource -> MultiPackResourceManagerMixin.readAndApply(resource, data)).toList();
        cir.setReturnValue(result);
    }

    @Inject(method={"listResources"}, at={@At(value="RETURN")}, cancellable=true)
    public void findConfiguredResources(String startingPath, Predicate<Identifier> allowedPathPredicate, CallbackInfoReturnable<Map<Identifier, Resource>> cir) {
        for (ConfiguredData data : ConfiguredData.INSTANCES) {
            if (!data.enabled.get().booleanValue() || !data.target.getPath().startsWith(startingPath + "/") || !allowedPathPredicate.test(data.target) || ((Map)cir.getReturnValue()).containsKey(data.target)) continue;
            ((Map)cir.getReturnValue()).put(data.target, MultiPackResourceManagerMixin.readAndApply(Optional.empty(), data));
        }
        List ids = ((Map)cir.getReturnValue()).keySet().stream().toList();
        for (Identifier id : ids) {
            ConfiguredData data = ConfiguredData.get(id);
            if (data == null || !data.enabled.get().booleanValue()) continue;
            ((Map)cir.getReturnValue()).replace(id, MultiPackResourceManagerMixin.readAndApply((Resource)((Map)cir.getReturnValue()).get(id), data));
        }
    }

    @Inject(method={"listResourceStacks"}, at={@At(value="RETURN")}, cancellable=true)
    public void findAllConfiguredResources(String startingPath, Predicate<Identifier> allowedPathPredicate, CallbackInfoReturnable<Map<Identifier, List<Resource>>> cir) {
        for (ConfiguredData data : ConfiguredData.INSTANCES) {
            if (!data.enabled.get().booleanValue() || !data.target.getPath().startsWith(startingPath) || !allowedPathPredicate.test(data.target) || ((Map)cir.getReturnValue()).containsKey(data.target)) continue;
            ((Map)cir.getReturnValue()).put(data.target, List.of(MultiPackResourceManagerMixin.readAndApply(Optional.empty(), data)));
        }
        List ids = ((Map)cir.getReturnValue()).keySet().stream().toList();
        for (Identifier id : ids) {
            ConfiguredData data = ConfiguredData.get(id);
            if (data == null || !data.enabled.get().booleanValue()) continue;
            ((Map)cir.getReturnValue()).replace(id, ((List)((Map)cir.getReturnValue()).get(id)).stream().map(resource -> MultiPackResourceManagerMixin.readAndApply(resource, data)).toList());
        }
    }

    @Override
    public boolean resourceExists(Identifier id) {
        return ((MultiPackResourceManager)this).getResource(id).isPresent();
    }
}

