/*
 * Decompiled with CFR 0.152.
 */
package org.octave.playershowcase.camera;

public final class CameraTransition {
    private static double value = 0.0;
    private static double target = 0.0;
    private static final double SPEED = 0.6;

    private CameraTransition() {
    }

    public static void startEnter() {
        target = 1.0;
    }

    public static void startExit() {
        target = 0.0;
    }

    public static void tick(double dt) {
        double diff = target - value;
        value += diff * Math.min(1.0, dt * 0.6);
    }

    public static double get() {
        return CameraTransition.ease(value);
    }

    public static boolean active() {
        return Math.abs(target - value) > 0.001;
    }

    private static double ease(double x) {
        return x * x * (3.0 - 2.0 * x);
    }
}

