/*
 * Decompiled with CFR 0.152.
 */
package org.octave.playershowcase.camera;

import java.util.Random;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.octave.playershowcase.camera.CameraTransition;
import org.octave.playershowcase.state.StateController;

public final class CinematicCameraController {
    private static final Random RND = new Random();
    private static final double DIST_MIN = 1.1;
    private static final double DIST_MAX = 1.55;
    private static final double MOVE_SPEED = 0.032;
    private static class_243 startPos;
    private static class_243 endPos;
    private static double time;
    private static float yaw;
    private static float pitch;
    private static Shot mode;

    public static boolean isActive() {
        return StateController.isCinematic() || CameraTransition.active();
    }

    public static class_243 getCameraPos(float step) {
        class_310 c = class_310.method_1551();
        double dt = (double)step / 20.0;
        time += dt * 0.032;
        if (startPos == null || time >= 1.0) {
            CinematicCameraController.chooseShot();
            CinematicCameraController.generatePath();
            time = 0.0;
        }
        double a = CinematicCameraController.smooth(time);
        class_243 cam = startPos.method_35590(endPos, a);
        class_243 focus = switch (mode.ordinal()) {
            case 2 -> CinematicCameraController.getHandPoint(c);
            case 4 -> CinematicCameraController.getChestPoint(c);
            default -> CinematicCameraController.getFacePoint(c);
        };
        CinematicCameraController.calculateLook(cam, focus);
        return cam;
    }

    private static void chooseShot() {
        int r = RND.nextInt(100);
        mode = r < 30 ? Shot.FACE_PORTRAIT : (r < 50 ? Shot.HALF_FACE : (r < 65 ? Shot.ITEM_HERO : (r < 80 ? Shot.APPROACH_FACE : (r < 92 ? Shot.HALF_BODY : Shot.SHOULDER))));
    }

    private static void generatePath() {
        class_310 c = class_310.method_1551();
        class_243 head = CinematicCameraController.getHeadPoint(c);
        class_243 chest = CinematicCameraController.getChestPoint(c);
        class_243 hand = CinematicCameraController.getHandPoint(c);
        double d1 = CinematicCameraController.lerp(1.1, 1.55, RND.nextDouble());
        double d2 = CinematicCameraController.lerp(1.1, 1.55, RND.nextDouble());
        float yawRad = (float)Math.toRadians(c.field_1724.method_36454());
        class_243 forward = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).method_1029();
        class_243 right = new class_243(-forward.field_1350, 0.0, forward.field_1352);
        switch (mode.ordinal()) {
            case 0: {
                startPos = head.method_1019(forward.method_1021(d1)).method_1019(right.method_1021(0.25));
                endPos = head.method_1019(forward.method_1021(d2)).method_1019(right.method_1021(-0.25));
                break;
            }
            case 1: {
                double side = RND.nextBoolean() ? 1.0 : -1.0;
                startPos = head.method_1019(forward.method_1021(d1 * 0.9)).method_1019(right.method_1021(0.45 * side));
                endPos = head.method_1019(forward.method_1021(d2 * 0.88)).method_1019(right.method_1021(0.4 * side));
                break;
            }
            case 2: {
                startPos = hand.method_1019(forward.method_1021(d1 * 0.75)).method_1019(right.method_1021(0.22));
                endPos = hand.method_1019(forward.method_1021(d2 * 0.72)).method_1019(right.method_1021(-0.22));
                break;
            }
            case 3: {
                double side = RND.nextBoolean() ? 1.0 : -1.0;
                startPos = chest.method_1019(forward.method_1021(d1 * 0.8)).method_1019(right.method_1021(0.38 * side));
                endPos = chest.method_1019(forward.method_1021(d2 * 0.78)).method_1019(right.method_1021(0.34 * side));
                break;
            }
            case 4: {
                startPos = chest.method_1019(forward.method_1021(d1)).method_1019(right.method_1021(0.2));
                endPos = chest.method_1019(forward.method_1021(d2)).method_1019(right.method_1021(-0.2));
                break;
            }
            case 5: {
                startPos = head.method_1019(forward.method_1021(d1 * 2.0)).method_1019(new class_243(0.0, 0.06, 0.0));
                endPos = head.method_1019(forward.method_1021(d2 * 1.1)).method_1019(new class_243(0.0, 0.02, 0.0));
            }
        }
        if (startPos.method_1022(endPos) < 0.12) {
            endPos = endPos.method_1019(right.method_1021(0.15));
        }
    }

    private static class_243 getHeadPoint(class_310 c) {
        return new class_243(c.field_1724.method_23317(), c.field_1724.method_23318() + 1.62, c.field_1724.method_23321());
    }

    private static class_243 getFacePoint(class_310 c) {
        return CinematicCameraController.getHeadPoint(c).method_1031(0.0, -0.04, 0.06);
    }

    private static class_243 getChestPoint(class_310 c) {
        return new class_243(c.field_1724.method_23317(), c.field_1724.method_23318() + 1.24, c.field_1724.method_23321());
    }

    private static class_243 getHandPoint(class_310 c) {
        class_243 body = CinematicCameraController.getChestPoint(c);
        return body.method_1031(0.22, -0.12, 0.18);
    }

    private static void calculateLook(class_243 from, class_243 to) {
        class_243 dir = to.method_1020(from).method_1029();
        yaw = (float)(Math.atan2(dir.field_1350, dir.field_1352) * 57.2958) - 90.0f;
        pitch = (float)(-(Math.asin(dir.field_1351) * 57.2958));
    }

    private static double smooth(double x) {
        return x * x * (3.0 - 2.0 * x);
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static float getYaw() {
        return yaw;
    }

    public static float getPitch() {
        return pitch;
    }

    static {
        time = 0.0;
        mode = Shot.FACE_PORTRAIT;
    }

    private static enum Shot {
        FACE_PORTRAIT,
        HALF_FACE,
        ITEM_HERO,
        SHOULDER,
        HALF_BODY,
        APPROACH_FACE;

    }
}

