/*
 * Decompiled with CFR 0.152.
 */
package org.octave.playershowcase.state;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import org.octave.playershowcase.afk.AfkTimer;
import org.octave.playershowcase.camera.CameraTransition;
import org.octave.playershowcase.state.ShowcaseState;

public final class StateController {
    private static ShowcaseState current = ShowcaseState.NORMAL;
    private static class_5498 previousPerspective = class_5498.field_26664;

    private StateController() {
    }

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (AfkTimer.isAfk() && current == ShowcaseState.NORMAL) {
                StateController.enterCinematic();
            }
            if (!AfkTimer.isAfk() && current == ShowcaseState.CINEMATIC) {
                StateController.exitCinematic();
            }
        });
    }

    private static void enterCinematic() {
        current = ShowcaseState.CINEMATIC;
        class_310 client = class_310.method_1551();
        previousPerspective = client.field_1690.method_31044();
        client.field_1690.method_31043(class_5498.field_26665);
        CameraTransition.startEnter();
        System.out.println("[PlayerShowcase] \u2192 CINEMATIC (third person forced)");
    }

    private static void exitCinematic() {
        current = ShowcaseState.NORMAL;
        class_310 client = class_310.method_1551();
        client.field_1690.method_31043(previousPerspective);
        CameraTransition.startExit();
        System.out.println("[PlayerShowcase] \u2192 NORMAL (perspective restored)");
    }

    public static boolean isCinematic() {
        return current == ShowcaseState.CINEMATIC;
    }

    public static ShowcaseState getState() {
        return current;
    }
}

