/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted;

import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.edu.resprouted.Resprouted;
import net.fabricmc.loader.api.FabricLoader;

public class ResproutedClientConfiguration {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "resprouted-client.json");
    public boolean bottleEffectTooltips = true;
    public boolean foodEffectTooltips = false;
    public List<String> effectOverlayBlacklist = new ArrayList<String>();

    public ResproutedClientConfiguration() {
        this.effectOverlayBlacklist.add("minecraft:shulker");
        this.effectOverlayBlacklist.add("minecraft:ender_dragon");
        this.effectOverlayBlacklist.add("minecraft:warden");
        this.effectOverlayBlacklist.add("minecraft:witch");
        this.effectOverlayBlacklist.add("minecraft:silverfish");
        this.effectOverlayBlacklist.add("minecraft:allay");
        this.effectOverlayBlacklist.add("minecraft:goat");
        this.effectOverlayBlacklist.add("minecraft:frog");
        this.effectOverlayBlacklist.add("minecraft:vex");
        this.effectOverlayBlacklist.add("minecraft:strider");
        this.effectOverlayBlacklist.add("minecraft:parrot");
    }

    public static ResproutedClientConfiguration load() {
        ResproutedClientConfiguration configuration = new ResproutedClientConfiguration();
        if (!CONFIG_FILE.exists()) {
            ResproutedClientConfiguration.save(configuration);
            Resprouted.LOGGER.info("Created new client config file for resprouted");
            return configuration;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());){
            configuration = (ResproutedClientConfiguration)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, ResproutedClientConfiguration.class);
            if (configuration.effectOverlayBlacklist == null) {
                configuration.effectOverlayBlacklist = new ArrayList<String>();
            }
            Resprouted.LOGGER.info("Client config loaded successfully for resprouted");
        }
        catch (IOException e) {
            Resprouted.LOGGER.error("Error loading Resprouted client config: {}", (Object)e.getMessage());
        }
        return configuration;
    }

    public static void save(ResproutedClientConfiguration config) {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            Resprouted.LOGGER.info("Client config saved successfully for resprouted");
        }
        catch (IOException e) {
            Resprouted.LOGGER.error("Error saving Resprouted client config: {}", (Object)e.getMessage());
        }
    }

    public boolean isBottleEffectTooltipsEnabled() {
        return this.bottleEffectTooltips;
    }

    public void setBottleEffectTooltips(boolean v) {
        this.bottleEffectTooltips = v;
    }

    public boolean isFoodEffectTooltipsEnabled() {
        return this.foodEffectTooltips;
    }

    public void setFoodEffectTooltips(boolean v) {
        this.foodEffectTooltips = v;
    }

    public boolean setEntityBlacklisted(String entityId) {
        return this.effectOverlayBlacklist != null && this.effectOverlayBlacklist.contains(entityId);
    }

    public List<String> getEffectOverlayBlacklist() {
        return this.effectOverlayBlacklist;
    }
}

