/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted;

import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.edu.resprouted.Resprouted;
import net.fabricmc.loader.api.FabricLoader;

public class ResproutedCommonConfiguration {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "resprouted-common.json");
    public GeneralSettings general = new GeneralSettings();
    public WorldSettings world = new WorldSettings();
    public FoodSettings food = new FoodSettings();
    public BrewingSettings brewing = new BrewingSettings();

    public static ResproutedCommonConfiguration load() {
        ResproutedCommonConfiguration configuration = new ResproutedCommonConfiguration();
        if (!CONFIG_FILE.exists()) {
            ResproutedCommonConfiguration.save(configuration);
            Resprouted.LOGGER.info("Created new common config file for resprouted");
            return configuration;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());){
            configuration = (ResproutedCommonConfiguration)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, ResproutedCommonConfiguration.class);
            Resprouted.LOGGER.info("Common config loaded successfully for resprouted");
        }
        catch (IOException e) {
            Resprouted.LOGGER.error("Error loading Resprouted common config: {}", (Object)e.getMessage());
        }
        return configuration;
    }

    public static void save(ResproutedCommonConfiguration config) {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            Resprouted.LOGGER.info("Common config saved successfully for resprouted");
        }
        catch (IOException e) {
            Resprouted.LOGGER.error("Error saving Resprouted common config: {}", (Object)e.getMessage());
        }
    }

    private static float limit(float min, float max, float value) {
        return Math.max(min, Math.min(max, value));
    }

    private static int limit(int min, int max, int value) {
        return Math.max(min, Math.min(max, value));
    }

    public GeneralSettings getGeneral() {
        return this.general;
    }

    public WorldSettings getWorld() {
        return this.world;
    }

    public FoodSettings getFood() {
        return this.food;
    }

    public BrewingSettings getBrewing() {
        return this.brewing;
    }

    public static class GeneralSettings {
        private boolean enableHoneyBottleRegenerationEffect = true;
        private boolean enableDyeByRightClick = false;
        private boolean enablePaintedPlanks = true;
        private boolean enableTables = true;
        private boolean enableChairs = true;
        private boolean enableStools = true;
        private boolean enableClayWalls = true;
        private boolean enableVanillaBlockVariations = true;
        private boolean enableVantaOiling = true;
        private List<String> vantaOilWhiteList = new ArrayList<String>();
        private List<String> vantaOilBlackList = new ArrayList<String>();

        public GeneralSettings() {
            this.vantaOilWhiteList.add("minecraft:bone");
            this.vantaOilWhiteList.add("farmersdelight:iron_knife");
            this.vantaOilWhiteList.add("farmersdelight:diamond_knife");
        }

        public boolean isEnablePaintedPlanks() {
            return this.enablePaintedPlanks;
        }

        public void setEnablePaintedPlanks(boolean enablePaintedPlanks) {
            this.enablePaintedPlanks = enablePaintedPlanks;
        }

        public boolean isEnableTables() {
            return this.enableTables;
        }

        public void setEnableTables(boolean enableTables) {
            this.enableTables = enableTables;
        }

        public boolean isEnableChairs() {
            return this.enableChairs;
        }

        public void setEnableChairs(boolean enableChairs) {
            this.enableChairs = enableChairs;
        }

        public boolean isEnableStools() {
            return this.enableStools;
        }

        public void setEnableStools(boolean enableStools) {
            this.enableStools = enableStools;
        }

        public boolean isEnableClayWalls() {
            return this.enableClayWalls;
        }

        public void setEnableClayWalls(boolean enableClayWallBlocks) {
            this.enableClayWalls = enableClayWallBlocks;
        }

        public boolean isEnableVanillaBlockVariations() {
            return this.enableVanillaBlockVariations;
        }

        public void setEnableVanillaBlockVariations(boolean enableVanillaBlockVariations) {
            this.enableVanillaBlockVariations = enableVanillaBlockVariations;
        }

        public boolean isEnableHoneyBottleRegenerationEffect() {
            return this.enableHoneyBottleRegenerationEffect;
        }

        public void setEnableHoneyBottleRegenerationEffect(boolean enableHoneyBottleRegenerationEffect) {
            this.enableHoneyBottleRegenerationEffect = enableHoneyBottleRegenerationEffect;
        }

        public boolean isEnableDyeByRightClick() {
            return this.enableDyeByRightClick;
        }

        public void setEnableDyeByRightClick(boolean enableDyeByRightClick) {
            this.enableDyeByRightClick = enableDyeByRightClick;
        }

        public boolean isEnableVantaOiling() {
            return this.enableVantaOiling;
        }

        public void setEnableVantaOiling(boolean enableVantaOiling) {
            this.enableVantaOiling = enableVantaOiling;
        }

        public List<String> getVantaOilWhiteList() {
            return this.vantaOilWhiteList;
        }

        public void setVantaOilWhiteList(List<String> vantaOilWhiteList) {
            this.vantaOilWhiteList = vantaOilWhiteList != null ? vantaOilWhiteList : new ArrayList();
        }

        public List<String> getVantaOilBlackList() {
            return this.vantaOilBlackList;
        }

        public void setVantaOilBlackList(List<String> vantaOilBlackList) {
            this.vantaOilBlackList = vantaOilBlackList != null ? vantaOilBlackList : new ArrayList();
        }
    }

    public static class WorldSettings {
        private boolean enableSeedDrops = true;
        private int seedsDropRate = 7;
        private boolean grapeDropNeedsTool = false;
        private List<String> grapeSeedsToolWhitelist = new ArrayList<String>();

        public WorldSettings() {
            this.grapeSeedsToolWhitelist.add("minecraft:iron_hoe");
            this.grapeSeedsToolWhitelist.add("minecraft:diamond_hoe");
            this.grapeSeedsToolWhitelist.add("minecraft:netherite_hoe");
        }

        public boolean isEnableSeedDrops() {
            return this.enableSeedDrops;
        }

        public void setEnableSeedDrops(boolean enableSeedDrops) {
            this.enableSeedDrops = enableSeedDrops;
        }

        public int getSeedsDropRate() {
            return this.seedsDropRate;
        }

        public void setSeedsDropRate(int seedsDropRate) {
            this.seedsDropRate = ResproutedCommonConfiguration.limit(1, 100, seedsDropRate);
        }

        public boolean isGrapeDropNeedsTool() {
            return this.grapeDropNeedsTool;
        }

        public void setGrapeDropNeedsTool(boolean grapeDropNeedsTool) {
            this.grapeDropNeedsTool = grapeDropNeedsTool;
        }

        public List<String> getGrapeSeedsToolWhitelist() {
            return this.grapeSeedsToolWhitelist;
        }

        public void setGrapeSeedsToolWhitelist(List<String> grapeSeedsToolWhitelist) {
            this.grapeSeedsToolWhitelist = grapeSeedsToolWhitelist != null ? grapeSeedsToolWhitelist : new ArrayList();
        }
    }

    public static class FoodSettings {
        private boolean enableOliveOiling = true;
        private int oiledNutritionBonus = 2;
        private float oiledSaturationModifier = 1.5f;
        private List<String> oilableFoodWhiteList = new ArrayList<String>();
        private List<String> oilableFoodBlackList = new ArrayList<String>();

        public FoodSettings() {
            this.oilableFoodWhiteList.add("farmersdelight:tomato");
            this.oilableFoodWhiteList.add("farmersdelight:onion");
            this.oilableFoodWhiteList.add("farmersdelight:cabbage_leaf");
        }

        public boolean isEnableOliveOiling() {
            return this.enableOliveOiling;
        }

        public void setEnableOliveOiling(boolean enableOliveOiling) {
            this.enableOliveOiling = enableOliveOiling;
        }

        public int getOiledNutritionBonus() {
            return this.oiledNutritionBonus;
        }

        public void setOiledNutritionBonus(int oiledNutritionBonus) {
            this.oiledNutritionBonus = ResproutedCommonConfiguration.limit(0, 10, oiledNutritionBonus);
        }

        public float getOiledSaturationModifier() {
            return this.oiledSaturationModifier;
        }

        public void setOiledSaturationModifier(float oiledSaturationModifier) {
            this.oiledSaturationModifier = ResproutedCommonConfiguration.limit(0.1f, 5.0f, oiledSaturationModifier);
        }

        public List<String> getOilableFoodWhiteList() {
            return this.oilableFoodWhiteList;
        }

        public void setOilableFoodWhiteList(List<String> oilableFoodWhiteList) {
            this.oilableFoodWhiteList = oilableFoodWhiteList != null ? oilableFoodWhiteList : new ArrayList();
        }

        public List<String> getOilableFoodBlackList() {
            return this.oilableFoodBlackList;
        }

        public void setOilableFoodBlackList(List<String> oilableFoodBlackList) {
            this.oilableFoodBlackList = oilableFoodBlackList != null ? oilableFoodBlackList : new ArrayList();
        }
    }

    public static class BrewingSettings {
        private int minBrewQualityChange = -1;
        private int maxBrewQualityChange = 4;
        private int maxBrewTime = 12000;

        public int getMinBrewQualityChange() {
            return this.minBrewQualityChange;
        }

        public void setMinBrewQualityChange(int minBrewQualityChange) {
            this.minBrewQualityChange = minBrewQualityChange;
        }

        public int getMaxBrewQualityChange() {
            return this.maxBrewQualityChange;
        }

        public void setMaxBrewQualityChange(int maxBrewQualityChange) {
            this.maxBrewQualityChange = maxBrewQualityChange;
        }

        public int getMaxBrewTime() {
            return this.maxBrewTime;
        }

        public void setMaxBrewTime(int maxBrewTime) {
            this.maxBrewTime = ResproutedCommonConfiguration.limit(200, 120000, maxBrewTime);
        }
    }
}

