/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.abstracts.entity;

import net.edu.resprouted.block.abstracts.entity.AbstractSingleFluidStorageBlockEntity;
import net.edu.resprouted.util.block.SmoothFloat;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public abstract class AbstractAnimatedSingleFluidStorageBlockEntity
extends AbstractSingleFluidStorageBlockEntity {
    private final SmoothFloat fluidAnimation = new SmoothFloat();
    private long lastFluidAmount = -1L;
    private boolean initialized = false;

    public AbstractAnimatedSingleFluidStorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, long capacity) {
        super(type, pos, state, capacity);
    }

    public void method_5431() {
        long currentAmount;
        super.method_5431();
        if (this.field_11863 != null && this.field_11863.field_9236 && (currentAmount = this.getFluidStorage().getAmount()) != this.lastFluidAmount) {
            float targetHeight = this.calculateTargetHeight();
            this.fluidAnimation.setTarget(targetHeight);
            this.lastFluidAmount = currentAmount;
        }
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            long currentAmount = this.getFluidStorage().getAmount();
            float targetHeight = this.calculateTargetHeight();
            if (!this.initialized) {
                this.fluidAnimation.set(targetHeight);
                this.lastFluidAmount = currentAmount;
                this.initialized = true;
            } else if (currentAmount != this.lastFluidAmount) {
                this.fluidAnimation.setTarget(targetHeight);
                this.lastFluidAmount = currentAmount;
            }
        }
    }

    protected float calculateTargetHeight() {
        long currentAmount = this.getFluidStorage().getAmount();
        long capacity = this.getFluidStorage().getCapacity();
        return class_3532.method_15363((float)((float)currentAmount / (float)capacity), (float)0.0f, (float)1.0f);
    }

    public void tickFluidAnimation() {
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.fluidAnimation.tick();
        }
    }

    public float getFluidHeight(float tickDelta) {
        return this.fluidAnimation.get(tickDelta);
    }
}

