/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.abstracts.entity;

import net.edu.resprouted.block.abstracts.AbstractCondenserBlock;
import net.edu.resprouted.block.abstracts.entity.AbstractSingleFluidStorageBlockEntity;
import net.edu.resprouted.block.interfaces.ImplementedInventory;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_7225;

public abstract class AbstractCondenserBlockEntity
extends AbstractSingleFluidStorageBlockEntity
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    protected final class_2371<class_1799> inventory;
    protected int burnTime = 0;
    protected int fuelTime = 0;
    protected int progress = 0;
    protected int maxProgress = 380;
    protected final class_3913 propertyDelegate;
    protected static final long RECIPE_FLUID_COST = 10125L;
    private int smokeTimer = 0;

    protected AbstractCondenserBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int inventorySize, long fluidCapacity) {
        super(type, pos, state, fluidCapacity);
        this.inventory = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
        this.propertyDelegate = this.createPropertyDelegate();
    }

    protected abstract class_3913 createPropertyDelegate();

    protected abstract boolean hasRecipe();

    protected abstract void craftItem();

    public abstract class_2561 method_5476();

    public abstract class_1703 createMenu(int var1, class_1661 var2, class_1657 var3);

    protected abstract void spawnSmokeParticles(class_1937 var1, class_2338 var2, class_2680 var3);

    protected abstract class_1799 getFuelStack();

    protected abstract void updateLitState(class_1937 var1, class_2338 var2, class_2680 var3, boolean var4);

    protected abstract int getOutputSlot();

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("condenser.progress", this.progress);
        nbt.method_10569("condenser.max_progress", this.maxProgress);
        nbt.method_10569("BurnTime", this.burnTime);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("condenser.progress");
        this.maxProgress = nbt.method_10550("condenser.max_progress");
        this.burnTime = nbt.method_10550("BurnTime");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void clientTick(class_1937 world, class_2338 pos, class_2680 state) {
        boolean shouldEmitSmoke;
        boolean bl = shouldEmitSmoke = this.progress > 0;
        if (shouldEmitSmoke) {
            ++this.smokeTimer;
            if (this.smokeTimer >= 3) {
                this.spawnSmokeParticles(world, pos, state);
                this.smokeTimer = 0;
            }
        }
    }

    public void serverTick(class_1937 world, class_2338 pos, class_2680 state) {
        boolean shouldBeLit;
        class_1799 fuelStack;
        int fuelBurnTime;
        boolean dirty = false;
        boolean hasFuelAvailable = this.hasFuel();
        if (!this.isBurning() && this.hasRecipe() && hasFuelAvailable && (fuelBurnTime = ((Integer)FuelRegistry.INSTANCE.get((class_1935)(fuelStack = this.getFuelStack()).method_7909())).intValue()) > 0) {
            this.burnTime = fuelBurnTime;
            this.fuelTime = fuelBurnTime;
            fuelStack.method_7934(1);
            dirty = true;
        }
        if (this.isBurning()) {
            --this.burnTime;
            if (this.hasRecipe()) {
                this.increaseCraftingProgress();
                if (this.hasCraftingFinished()) {
                    this.craftItem();
                    this.resetProgress();
                    dirty = true;
                }
            } else {
                this.resetProgress();
            }
            AbstractCondenserBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        } else {
            this.resetProgress();
        }
        boolean bl = shouldBeLit = this.isBurning() || hasFuelAvailable && this.hasRecipe();
        if ((Boolean)state.method_11654((class_2769)AbstractCondenserBlock.LIT) != shouldBeLit) {
            this.updateLitState(world, pos, state, shouldBeLit);
            dirty = true;
        }
        if (dirty) {
            AbstractCondenserBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    protected void spawnSmoke(class_1937 world, double x, double y, double z) {
        double yVel = 0.06;
        double randomOffsetY = world.field_9229.method_43058() * 0.02;
        world.method_8406((class_2394)class_2398.field_11251, x, y + randomOffsetY, z, 0.0, yVel, 0.0);
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public boolean hasFluid() {
        SingleFluidStorage fluidStorage = this.getFluidStorage();
        return !((FluidVariant)fluidStorage.variant).isBlank() && fluidStorage.amount >= 10125L && ((FluidVariant)fluidStorage.variant).isOf((Object)class_3612.field_15910);
    }

    protected boolean hasFuel() {
        class_1799 fuelStack = this.getFuelStack();
        return !fuelStack.method_7960() && (Integer)FuelRegistry.INSTANCE.get((class_1935)fuelStack.method_7909()) > 0;
    }

    protected void resetProgress() {
        if (this.progress != 0) {
            this.progress = 0;
            this.method_5431();
            if (this.field_11863 != null) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    protected boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    protected void increaseCraftingProgress() {
        ++this.progress;
        if (this.progress % 20 == 0) {
            this.method_5431();
            if (this.field_11863 != null) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    protected boolean canInsertIntoOutputSlot(class_1799 result) {
        class_1799 outputStack = this.method_5438(this.getOutputSlot());
        if (outputStack.method_7960()) {
            return true;
        }
        return class_1799.method_31577((class_1799)outputStack, (class_1799)result) && outputStack.method_7947() + result.method_7947() <= outputStack.method_7914();
    }

    protected void consumeFluidAndFinishCrafting() {
        SingleFluidStorage fluidStorage = this.getFluidStorage();
        fluidStorage.amount -= 10125L;
        if (fluidStorage.amount < 0L) {
            fluidStorage.amount = 0L;
        }
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    protected class_2350 getRelativeSide(class_2350 worldSide, class_2350 facing) {
        if (worldSide == class_2350.field_11036 || worldSide == class_2350.field_11033) {
            return worldSide;
        }
        if (worldSide == facing.method_10153()) {
            return class_2350.field_11043;
        }
        if (worldSide == facing) {
            return class_2350.field_11035;
        }
        if (worldSide == facing.method_10170()) {
            return class_2350.field_11034;
        }
        if (worldSide == facing.method_10160()) {
            return class_2350.field_11039;
        }
        return worldSide;
    }
}

