/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.custom.agriculture;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.edu.resprouted.block.ModBlockEntities;
import net.edu.resprouted.block.entity.custom.agriculture.CrushingTubBlockEntity;
import net.edu.resprouted.block.interfaces.LuminousFluidStorage;
import net.edu.resprouted.fluid.data.FluidItemMapping;
import net.edu.resprouted.recipe.custom.CrushingTubRecipe;
import net.edu.resprouted.recipe.helper.RecipeOutput;
import net.edu.resprouted.resource.FluidItemLoader;
import net.edu.resprouted.util.fluid.FluidItemInteractionHelper;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class CrushingTubBlock
extends class_2237
implements LuminousFluidStorage,
class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final MapCodec<CrushingTubBlock> CODEC = CrushingTubBlock.method_54094(CrushingTubBlock::new);

    public CrushingTubBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT_LEVEL, WATERLOGGED});
    }

    @Override
    @Nullable
    public class_2586 getBlockEntity(class_1937 world, class_2338 pos) {
        return world.method_8321(pos);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CrushingTubBlockEntity(pos, state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        CrushingTubBlockEntity crushingTub;
        class_1799 i;
        class_2586 be;
        if (!state.method_27852(newState.method_26204()) && (be = world.method_8321(pos)) instanceof CrushingTubBlockEntity && !(i = (crushingTub = (CrushingTubBlockEntity)be).method_5438(0)).method_7960()) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)i);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? CrushingTubBlock.method_31618(type, ModBlockEntities.CRUSHING_TUB_BE, CrushingTubBlockEntity::tick) : null;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof CrushingTubBlockEntity)) {
            return class_9062.field_47733;
        }
        CrushingTubBlockEntity ct = (CrushingTubBlockEntity)be;
        Storage fluidStorage = (Storage)FluidStorage.SIDED.find(world, pos, (Object)hit.method_17780());
        boolean hasFluid = this.hasFluidInStorage((Storage<FluidVariant>)fluidStorage);
        boolean isEmptyFluidExtractor = this.isEmptyFluidExtractor(stack);
        if (isEmptyFluidExtractor && hasFluid) {
            if (world.field_9236) {
                return class_9062.field_47728;
            }
            class_9062 fluidResult = FluidItemInteractionHelper.onFluidStorageUse(player, stack, (Storage<FluidVariant>)fluidStorage, world, pos, false, true);
            if (fluidResult == class_9062.field_47728) {
                this.updateBlockWithLight(ct, world, pos, state);
                return class_9062.field_47728;
            }
            return class_9062.field_47733;
        }
        class_1799 stored = ct.method_5438(0);
        if (stack.method_7960()) {
            return this.handleItemExtraction(ct, world, pos, state, player, stored);
        }
        return this.handleItemInsertion(ct, world, pos, state, player, hand, stack, stored);
    }

    private boolean isEmptyFluidExtractor(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        for (FluidItemMapping mapping : FluidItemLoader.getEntries()) {
            if (!mapping.direction().allowsExtract() || !stack.method_31574(mapping.emptyItem().method_7909())) continue;
            return true;
        }
        return false;
    }

    private boolean hasFluidInStorage(Storage<FluidVariant> storage) {
        if (storage == null) {
            return false;
        }
        for (StorageView view : storage) {
            if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
            return true;
        }
        return false;
    }

    private class_9062 handleItemExtraction(CrushingTubBlockEntity ct, class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1799 stored) {
        if (stored.method_7960()) {
            return class_9062.field_47733;
        }
        player.method_31548().method_7398(stored.method_7972());
        ct.method_5447(0, class_1799.field_8037);
        this.updateBlockWithLight(ct, world, pos, state);
        world.method_8396(player, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 1.5f);
        return class_9062.field_47728;
    }

    private class_9062 handleItemInsertion(CrushingTubBlockEntity ct, class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand, class_1799 stack, class_1799 stored) {
        int maxTransfer;
        if (stored.method_7960()) {
            ct.method_5447(0, stack.method_7972());
            player.method_6122(hand, class_1799.field_8037);
            this.updateBlockWithLight(ct, world, pos, state);
            world.method_8396(player, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 1.0f);
            return class_9062.field_47728;
        }
        if (class_1799.method_31577((class_1799)stored, (class_1799)stack) && (maxTransfer = Math.min(stack.method_7947(), stored.method_7914() - stored.method_7947())) > 0) {
            stored.method_7933(maxTransfer);
            stack.method_7934(maxTransfer);
            this.updateBlockWithLight(ct, world, pos, state);
            world.method_8396(player, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 1.0f);
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        entity.method_5747(fallDistance, 1.0f, entity.method_48923().method_48827());
        if (world.field_9236 || !(entity instanceof class_1657)) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof CrushingTubBlockEntity)) {
            return;
        }
        CrushingTubBlockEntity ct = (CrushingTubBlockEntity)class_25862;
        class_1799 input = ct.method_5438(0);
        if (input.method_7960()) {
            return;
        }
        Optional<CrushingTubRecipe> recipeOpt = ct.findMatchingRecipe();
        if (recipeOpt.isEmpty()) {
            return;
        }
        CrushingTubRecipe recipe = recipeOpt.get();
        FluidVariant recipeFluid = recipe.fluidOutput();
        if (!recipeFluid.isBlank()) {
            boolean hasSpace;
            FluidVariant currentFluid = (FluidVariant)ct.getFluidStorage().getResource();
            long currentAmount = ct.getFluidStorage().getAmount();
            long maxCapacity = 648000L;
            boolean fluidsCompatible = currentFluid.isBlank() || currentFluid.equals((Object)recipeFluid);
            boolean bl = hasSpace = currentAmount + recipe.fluidAmount() <= maxCapacity;
            if (!fluidsCompatible || !hasSpace) {
                return;
            }
        }
        class_1799 inputCopy = input.method_7972();
        if (!this.processCrushing(ct, recipe)) {
            return;
        }
        this.updateBlockWithLight(ct, world, pos, state);
        this.playEffects(world, pos, inputCopy, recipe);
    }

    private boolean processCrushing(CrushingTubBlockEntity ct, CrushingTubRecipe recipe) {
        try (Transaction tx = Transaction.openOuter();){
            long inserted;
            FluidVariant recipeFluid = recipe.fluidOutput();
            if (!recipeFluid.isBlank() && recipe.fluidAmount() > 0L && (inserted = ct.getFluidStorage().insert((TransferVariant)recipeFluid, recipe.fluidAmount(), (TransactionContext)tx)) != recipe.fluidAmount()) {
                boolean bl = false;
                return bl;
            }
            ct.method_5434(0, 1);
            tx.commit();
            boolean bl = true;
            return bl;
        }
    }

    private void playEffects(class_1937 world, class_2338 pos, class_1799 input, CrushingTubRecipe recipe) {
        class_3414 crushSound = recipe.getCrushSound();
        world.method_8396(null, pos, crushSound, class_3419.field_15245, 1.0f, 1.0f);
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_1799 particleStack = input.method_46651(1);
        serverWorld.method_14199((class_2394)new class_2392(class_2398.field_11218, particleStack), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.6, (double)pos.method_10260() + 0.5, 5, 0.2, 0.1, 0.2, 0.05);
        this.spawnOutputItem(serverWorld, pos, recipe);
    }

    private void spawnOutputItem(class_3218 world, class_2338 pos, CrushingTubRecipe recipe) {
        if (recipe.outputItems().isEmpty()) {
            return;
        }
        for (RecipeOutput output : recipe.outputItems()) {
            class_1799 itemToSpawn;
            if (world.field_9229.method_43057() >= output.chance() || (itemToSpawn = output.stack().method_7972()).method_7960()) continue;
            float midHeight = class_1299.field_6052.method_17686() / 2.0f;
            double x = (double)pos.method_10263() + 0.5 + world.field_9229.method_43058() * 0.5 - 0.25;
            double y = (double)pos.method_10264() + 0.5 + world.field_9229.method_43058() * 0.5 - 0.25 - (double)midHeight;
            double z = (double)pos.method_10260() + 0.5 + world.field_9229.method_43058() * 0.5 - 0.25;
            class_1542 item = new class_1542((class_1937)world, x, y, z, itemToSpawn);
            item.method_18800(world.field_9229.method_43385(0.0, 0.1), 0.2 + world.field_9229.method_43058() * 0.1, world.field_9229.method_43385(0.0, 0.1));
            item.method_6982(10);
            world.method_8649((class_1297)item);
        }
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
}

