/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.custom.agriculture;

import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.block.custom.agriculture.RopeBlock;
import net.edu.resprouted.block.custom.agriculture.StakeBlock;
import net.edu.resprouted.item.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9062;

public class GrapeLeavesBlock
extends class_2248
implements class_2256 {
    private static final class_265 BRANCH_Z_SHAPE = class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0);
    private static final class_265 BRANCH_X_SHAPE = class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    private static final class_265 FULL_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final class_2758 DIST = class_2758.method_11867((String)"distance", (int)0, (int)1);
    public static final class_2758 AGE = class_2758.method_11867((String)"age", (int)0, (int)3);
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    public static final int MAX_AGE = 3;

    public GrapeLeavesBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)DIST, (Comparable)Integer.valueOf(0))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE, AXIS, DIST});
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)DIST) > 0) {
            return !this.isMature(state) && world.method_22347(pos.method_10074());
        }
        return this.canSpread((class_1937)world, pos, state);
    }

    protected boolean isMature(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 3;
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564();
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return false;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!state.method_27852(newState.method_26204()) && !world.field_9236) {
            world.method_8652(pos, (class_2680)ModBlocks.ROPE.method_9564().method_11657((class_2769)RopeBlock.field_11459, (Comparable)((class_2350.class_2351)state.method_11654(AXIS))), 3);
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(world, pos, state, player);
        if (!world.field_9236 && !player.method_7337()) {
            class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
        }
        return state;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        class_2350 i;
        if (!world.field_9236 && (i = this.getDirectionFromNeighbor(pos, fromPos)) != null && state.method_11654(AXIS) == i.method_10166() && world.method_22347(fromPos)) {
            if (i == class_2350.field_11033) {
                world.method_22352(pos, true);
            } else if (this.isBlockSupported(world, pos, state)) {
                world.method_22352(pos, true);
            }
        }
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        int j = (Integer)state.method_11654((class_2769)DIST);
        int k = (Integer)state.method_11654((class_2769)AGE);
        if (j > 0 && k < 3 && world.method_22347(pos.method_10074())) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(Math.min(k + 1, 3))), 3);
        } else if (j < 1) {
            this.spread((class_1937)world, pos, state);
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.isBlockSupported((class_1937)world, pos, state)) {
            world.method_22352(pos, true);
            return;
        }
        if (world.method_22339(pos.method_10084()) >= 9) {
            int l = (Integer)state.method_11654((class_2769)DIST);
            int m = (Integer)state.method_11654((class_2769)AGE);
            if (l > 0 && m < 3 && world.method_22347(pos.method_10074())) {
                if (random.method_43048((int)(35.0f / this.getGrowthChance()) + 1) == 0) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(m + 1)), 3);
                }
            } else if (l == 0 && this.canSpread((class_1937)world, pos, state) && random.method_43048((int)(30.0f / this.getGrowthChance()) + 1) == 0) {
                this.spread((class_1937)world, pos, state);
            }
        }
    }

    protected float getGrowthChance() {
        return 7.0f;
    }

    public static int getMaxAge() {
        return 3;
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.isMature(state)) {
            player.method_7270(new class_1799((class_1935)this.getHarvest()));
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 3);
            world.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1.0f, 1.0f);
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        super.method_19286(world, state, hit, projectile);
        if (!world.field_9236 && this.isMature(state)) {
            class_2338 pos = hit.method_17777();
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)this.getHarvest()));
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 3);
            world.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    protected class_1792 getHarvest() {
        return ModItems.GRAPES;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if ((Integer)state.method_11654((class_2769)DIST) < 1) {
            return FULL_SHAPE;
        }
        return state.method_11654(AXIS) == class_2350.class_2351.field_11051 ? BRANCH_Z_SHAPE : BRANCH_X_SHAPE;
    }

    private boolean isBlockSupported(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_11654(AXIS) == class_2350.class_2351.field_11048) {
            return this.isSideSupported(world, pos, state, class_2350.field_11039) || this.isSideSupported(world, pos, state, class_2350.field_11034);
        }
        if (state.method_11654(AXIS) == class_2350.class_2351.field_11051) {
            return this.isSideSupported(world, pos, state, class_2350.field_11043) || this.isSideSupported(world, pos, state, class_2350.field_11035);
        }
        return false;
    }

    private boolean isSideSupported(class_1937 world, class_2338 pos, class_2680 state, class_2350 facing) {
        if (facing == class_2350.field_11033) {
            return true;
        }
        class_2680 n = world.method_8320(pos.method_10093(facing));
        boolean isSame = n.method_26204() instanceof GrapeLeavesBlock && n.method_11654(AXIS) == state.method_11654(AXIS);
        boolean isRope = n.method_27852(ModBlocks.ROPE) && n.method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
        boolean isSideSolid = n.method_26206((class_1922)world, pos.method_10093(facing), facing.method_10153());
        boolean isTiedStake = n.method_26204() instanceof StakeBlock && ((StakeBlock)n.method_26204()).hasRope(n);
        return !isSame && !isRope && !isSideSolid && !isTiedStake;
    }

    private class_2350 getDirectionFromNeighbor(class_2338 pos, class_2338 fromPos) {
        if (fromPos.method_10263() != pos.method_10263()) {
            return fromPos.method_10263() - pos.method_10263() < 0 ? class_2350.field_11039 : class_2350.field_11034;
        }
        if (fromPos.method_10264() != pos.method_10264()) {
            return fromPos.method_10264() - pos.method_10264() < 0 ? class_2350.field_11033 : class_2350.field_11036;
        }
        if (fromPos.method_10260() != pos.method_10260()) {
            return fromPos.method_10260() - pos.method_10260() < 0 ? class_2350.field_11043 : class_2350.field_11035;
        }
        return null;
    }

    private boolean canSpread(class_1937 world, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)DIST) == 0) {
            switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                case field_11048: {
                    return world.method_8320(pos.method_10067()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10067()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS) || world.method_8320(pos.method_10078()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10078()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
                }
                case field_11051: {
                    return world.method_8320(pos.method_10095()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10095()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS) || world.method_8320(pos.method_10072()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10072()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
                }
            }
        }
        return false;
    }

    private void spread(class_1937 world, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)DIST) < 1) {
            switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                case field_11048: {
                    boolean eastRope;
                    boolean westRope = world.method_8320(pos.method_10067()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10067()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
                    boolean bl = eastRope = world.method_8320(pos.method_10078()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10078()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
                    if (westRope && eastRope) {
                        this.spreadToValidRope(world, world.field_9229.method_43056() ? pos.method_10067() : pos.method_10078());
                        break;
                    }
                    if (westRope) {
                        this.spreadToValidRope(world, pos.method_10067());
                        break;
                    }
                    if (!eastRope) break;
                    this.spreadToValidRope(world, pos.method_10078());
                    break;
                }
                case field_11051: {
                    boolean south;
                    boolean north = world.method_8320(pos.method_10095()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10095()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
                    boolean bl = south = world.method_8320(pos.method_10072()).method_27852(ModBlocks.ROPE) && world.method_8320(pos.method_10072()).method_11654((class_2769)RopeBlock.field_11459) == state.method_11654(AXIS);
                    if (north && south) {
                        this.spreadToValidRope(world, world.field_9229.method_43056() ? pos.method_10095() : pos.method_10072());
                        break;
                    }
                    if (north) {
                        this.spreadToValidRope(world, pos.method_10095());
                        break;
                    }
                    if (!south) break;
                    this.spreadToValidRope(world, pos.method_10072());
                }
            }
        }
    }

    private void spreadToValidRope(class_1937 world, class_2338 pos) {
        class_2680 o = world.method_8320(pos);
        if (o.method_27852(ModBlocks.ROPE)) {
            class_2350.class_2351 axis = (class_2350.class_2351)o.method_11654((class_2769)RopeBlock.field_11459);
            world.method_8652(pos, (class_2680)((class_2680)this.method_9564().method_11657(AXIS, (Comparable)axis)).method_11657((class_2769)DIST, (Comparable)Integer.valueOf(1)), 3);
        }
    }
}

