/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.custom.decorative;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.edu.resprouted.block.ModBlockEntities;
import net.edu.resprouted.block.entity.custom.decorative.CabinetBlockEntity;
import net.edu.resprouted.block.enums.CabinetType;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CabinetBlock
extends class_2237
implements class_3737,
class_3954 {
    public static final class_2746 OPEN = class_2746.method_11825((String)"open");
    public static final class_2753 FACING = class_2383.field_11177;
    public static final MapCodec<CabinetBlock> CODEC = CabinetBlock.method_54094(CabinetBlock::new);
    public static final class_2754<class_2750> HINGE = class_2741.field_12520;
    public static final class_2754<CabinetType> CABINET_TYPE = class_2754.method_11850((String)"cabinet_type", CabinetType.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_4732.class_3923<CabinetBlockEntity, Optional<class_1263>> INVENTORY_RETRIEVER = new class_4732.class_3923<CabinetBlockEntity, Optional<class_1263>>(){

        public Optional<class_1263> getFromBoth(CabinetBlockEntity first, CabinetBlockEntity second) {
            return Optional.of(new class_1258((class_1263)second, (class_1263)first));
        }

        public Optional<class_1263> getFrom(CabinetBlockEntity single) {
            return Optional.of(single);
        }

        public Optional<class_1263> getFallback() {
            return Optional.empty();
        }
    };
    private static final class_4732.class_3923<CabinetBlockEntity, Optional<class_3908>> NAME_RETRIEVER = new class_4732.class_3923<CabinetBlockEntity, Optional<class_3908>>(){

        public Optional<class_3908> getFromBoth(final CabinetBlockEntity first, final CabinetBlockEntity second) {
            class_1258 inventory = new class_1258((class_1263)second, (class_1263)first);
            return Optional.of(new class_3908(){
                final /* synthetic */ class_1263 val$inventory;
                {
                    this.val$inventory = class_12632;
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    if (first.method_17489(player) && second.method_17489(player)) {
                        first.method_54873(player);
                        second.method_54873(player);
                        return class_1707.method_19247((int)syncId, (class_1661)inv, (class_1263)this.val$inventory);
                    }
                    return null;
                }

                public class_2561 method_5476() {
                    if (first.method_16914()) {
                        return first.method_5476();
                    }
                    return second.method_16914() ? second.method_5476() : class_2561.method_43471((String)"container.resprouted.cabinet_double");
                }
            });
        }

        public Optional<class_3908> getFrom(CabinetBlockEntity single) {
            return Optional.of(single);
        }

        public Optional<class_3908> getFallback() {
            return Optional.empty();
        }
    };

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public CabinetBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(CABINET_TYPE, (Comparable)((Object)CabinetType.SINGLE))).method_11657(HINGE, (Comparable)class_2750.field_12588)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN, CABINET_TYPE, HINGE, WATERLOGGED});
    }

    public static class_4732.class_4733 getDoubleBlockType(class_2680 state) {
        CabinetType type = (CabinetType)((Object)state.method_11654(CABINET_TYPE));
        if (type == CabinetType.SINGLE) {
            return class_4732.class_4733.field_21783;
        }
        return type == CabinetType.BOTTOM ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        CabinetType type;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if ((type = (CabinetType)((Object)state.method_11654(CABINET_TYPE))) != CabinetType.SINGLE) {
            class_2350 expectedDir;
            class_2350 class_23502 = expectedDir = type == CabinetType.TOP ? class_2350.field_11033 : class_2350.field_11036;
            if (!(direction != expectedDir || neighborState.method_26204() instanceof CabinetBlock && neighborState.method_11654(CABINET_TYPE) == type.getOpposite() && neighborState.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && neighborState.method_11654(HINGE) == state.method_11654(HINGE))) {
                return (class_2680)state.method_11657(CABINET_TYPE, (Comparable)((Object)CabinetType.SINGLE));
            }
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CabinetBlockEntity(pos, state);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7618((class_1263)CabinetBlock.getInventory(this, state, world, pos, false));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2338 below = pos.method_10074();
        class_2350 facing = ctx.method_8042().method_10153();
        class_2750 hinge = this.getHingeSide(ctx);
        class_3610 fluidState = world.method_8316(pos);
        class_2680 belowState = world.method_8320(below);
        if (belowState.method_26204() instanceof CabinetBlock && belowState.method_11654((class_2769)FACING) == facing && belowState.method_11654(CABINET_TYPE) == CabinetType.SINGLE && belowState.method_11654(HINGE) == hinge) {
            return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(CABINET_TYPE, (Comparable)((Object)CabinetType.TOP))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)hinge)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(CABINET_TYPE, (Comparable)((Object)CabinetType.SINGLE))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)hinge)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    private class_2750 getHingeSide(class_1750 context) {
        class_2350 facing = context.method_8042();
        double hitX = context.method_17698().field_1352 - (double)context.method_8037().method_10263();
        double hitZ = context.method_17698().field_1350 - (double)context.method_8037().method_10260();
        return switch (facing) {
            case class_2350.field_11043 -> {
                if (hitX >= 0.5) {
                    yield class_2750.field_12586;
                }
                yield class_2750.field_12588;
            }
            case class_2350.field_11035 -> {
                if (hitX < 0.5) {
                    yield class_2750.field_12586;
                }
                yield class_2750.field_12588;
            }
            case class_2350.field_11039 -> {
                if (hitZ < 0.5) {
                    yield class_2750.field_12586;
                }
                yield class_2750.field_12588;
            }
            case class_2350.field_11034 -> {
                if (hitZ >= 0.5) {
                    yield class_2750.field_12586;
                }
                yield class_2750.field_12588;
            }
            default -> class_2750.field_12588;
        };
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2350 dirToOther;
        class_2338 otherPos;
        class_2680 otherState;
        CabinetType type;
        if (!world.field_9236 && (type = (CabinetType)((Object)state.method_11654(CABINET_TYPE))) != CabinetType.SINGLE && (otherState = world.method_8320(otherPos = pos.method_10093(dirToOther = type == CabinetType.TOP ? class_2350.field_11033 : class_2350.field_11036))).method_26204() instanceof CabinetBlock && otherState.method_11654(CABINET_TYPE) == CabinetType.SINGLE) {
            world.method_8652(otherPos, (class_2680)otherState.method_11657(CABINET_TYPE, (Comparable)((Object)type.getOpposite())), 3);
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (hit.method_17780() != state.method_11654((class_2769)FACING)) {
            return class_1269.field_5811;
        }
        if (this.isBlocked((class_1936)world, pos)) {
            return class_1269.field_21466;
        }
        class_3908 factory = this.method_17454(state, world, pos);
        if (factory != null) {
            player.method_17355(factory);
        }
        return class_1269.field_21466;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_4732.class_4734<? extends CabinetBlockEntity> getBlockEntitySource(class_2680 state, class_1937 world, class_2338 pos, boolean ignoreBlocked) {
        BiPredicate<class_1936, class_2338> blockPredicate = ignoreBlocked ? (w, p) -> false : this::isBlocked;
        return class_4732.method_24173(ModBlockEntities.CABINET_BE, CabinetBlock::getDoubleBlockType, CabinetBlock::getDirectionTowardsOtherHalf, (class_2753)FACING, (class_2680)state, (class_1936)world, (class_2338)pos, blockPredicate);
    }

    private static class_2350 getDirectionTowardsOtherHalf(class_2680 state) {
        CabinetType type = (CabinetType)((Object)state.method_11654(CABINET_TYPE));
        return type == CabinetType.BOTTOM ? class_2350.field_11036 : class_2350.field_11033;
    }

    @Nullable
    protected class_3908 method_17454(class_2680 state, class_1937 world, class_2338 pos) {
        return ((Optional)this.getBlockEntitySource(state, world, pos, false).apply(NAME_RETRIEVER)).orElse(null);
    }

    @Nullable
    public static class_1263 getInventory(CabinetBlock block, class_2680 state, class_1937 world, class_2338 pos, boolean ignoreBlocked) {
        return ((Optional)block.getBlockEntitySource(state, world, pos, ignoreBlocked).apply(INVENTORY_RETRIEVER)).orElse(null);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CabinetBlockEntity) {
            CabinetBlockEntity cabinetBE = (CabinetBlockEntity)blockEntity;
            cabinetBE.onScheduledTick();
        }
    }

    private boolean isBlocked(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return this.hasBlockInFront(world, pos, state) || CabinetBlock.hasCatInFront(world, pos, state);
    }

    private boolean hasBlockInFront(class_1936 world, class_2338 pos, class_2680 state) {
        class_2338 frontPos = pos.method_10093((class_2350)state.method_11654((class_2769)FACING));
        class_2680 frontState = world.method_8320(frontPos);
        return frontState.method_26212((class_1922)world, frontPos);
    }

    private static boolean hasCatInFront(class_1936 world, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 frontPos = pos.method_10093(facing);
        List list = world.method_18467(class_1451.class, new class_238((double)frontPos.method_10263(), (double)frontPos.method_10264(), (double)frontPos.method_10260(), (double)(frontPos.method_10263() + 1), (double)(frontPos.method_10264() + 1), (double)(frontPos.method_10260() + 1)));
        for (class_1451 catEntity : list) {
            if (!catEntity.method_6172()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        final class_1263 inventory = CabinetBlock.getInventory(this, state, (class_1937)world, pos, false);
        if (inventory == null) {
            return null;
        }
        return new class_1278(){

            public int[] method_5494(class_2350 side) {
                int[] slots = new int[inventory.method_5439()];
                for (int i = 0; i < slots.length; ++i) {
                    slots[i] = i;
                }
                return slots;
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return true;
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }

            public int method_5439() {
                return inventory.method_5439();
            }

            public boolean method_5442() {
                return inventory.method_5442();
            }

            public class_1799 method_5438(int slot) {
                return inventory.method_5438(slot);
            }

            public class_1799 method_5434(int slot, int amount) {
                return inventory.method_5434(slot, amount);
            }

            public class_1799 method_5441(int slot) {
                return inventory.method_5441(slot);
            }

            public void method_5447(int slot, class_1799 stack) {
                inventory.method_5447(slot, stack);
            }

            public void method_5431() {
                inventory.method_5431();
            }

            public boolean method_5443(class_1657 player) {
                return inventory.method_5443(player);
            }

            public void method_5448() {
                inventory.method_5448();
            }
        };
    }
}

