/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.custom.decorative;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.edu.resprouted.Resprouted;
import net.edu.resprouted.block.ModBlockEntities;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.block.entity.custom.decorative.JarBlockEntity;
import net.edu.resprouted.block.interfaces.LuminousFluidStorage;
import net.edu.resprouted.util.block.BlockUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5689;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class JarBlock
extends class_2237
implements LuminousFluidStorage,
class_3737 {
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final MapCodec<JarBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1767.field_41600.optionalFieldOf("color").forGetter(block -> Optional.ofNullable(block.color)), (App)JarBlock.method_54096()).apply((Applicative)instance, (color, settings) -> new JarBlock((class_4970.class_2251)settings, color.orElse(null))));
    public static final class_265 CLOSED_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (class_265[])new class_265[]{class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), class_2248.method_9541((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), class_2248.method_9541((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)});
    public static final class_265 OPEN_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (class_265[])new class_265[]{class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), class_2248.method_9541((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)});
    @Nullable
    private final class_1767 color;

    public JarBlock(class_4970.class_2251 settings, @Nullable class_1767 color) {
        super(settings);
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{OPEN, WATERLOGGED, LIGHT_LEVEL});
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new JarBlockEntity(this.color, pos, state);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        BlockUtils.appendFluidTooltip(stack, tooltip);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof JarBlockEntity) {
            JarBlockEntity jar = (JarBlockEntity)blockEntity;
            if (!world.field_9236 && player.method_7337() && !jar.getFluidStorage().isResourceBlank()) {
                class_2248 coloredBlock = JarBlock.get(jar.getColor());
                class_1799 stack = new class_1799((class_1935)coloredBlock);
                stack.method_57365(jar.method_57590());
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof JarBlockEntity) {
            JarBlockEntity jar = (JarBlockEntity)blockEntity;
            class_2248 coloredBlock = JarBlock.get(jar.getColor());
            class_1799 stack = new class_1799((class_1935)coloredBlock);
            stack.method_57365(jar.method_57590());
            return List.of(stack);
        }
        return List.of(new class_1799((class_1935)this));
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862;
        class_3611 fluid;
        class_2338 dripPos = class_5689.method_32767((class_1937)world, (class_2338)pos);
        if (dripPos != null && (fluid = class_5689.method_32775((class_3218)world, (class_2338)dripPos)) != class_3612.field_15906 && BlockUtils.canBeFilledByDripstone(fluid) && (class_25862 = world.method_8321(pos)) instanceof JarBlockEntity) {
            JarBlockEntity jar = (JarBlockEntity)class_25862;
            BlockUtils.fillFromDripstone(state, (class_1937)world, pos, fluid, jar.getFluidStorage(), this);
        }
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof JarBlockEntity) {
            JarBlockEntity jar = (JarBlockEntity)class_25862;
            BlockUtils.handlePrecipitation(state, world, pos, precipitation, jar.getFluidStorage(), this);
        }
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_9062 result;
        if (Resprouted.COMMON_CONFIG.getGeneral().isEnableDyeByRightClick() && (result = BlockUtils.tryToDye(world, pos, state, player, stack, JarBlock::get)) != class_9062.field_47731) {
            return result;
        }
        if (player.method_5715()) {
            return class_9062.field_47731;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof JarBlockEntity)) {
            return class_9062.field_47733;
        }
        if (!((Boolean)state.method_11654((class_2769)OPEN)).booleanValue()) {
            if (!world.field_9236) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.resprouted.jar_closed").method_27692(class_124.field_1070), true);
            }
            return class_9062.field_47729;
        }
        return BlockUtils.handleFluidInteraction(world, pos, player, hand, hit, this, state);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (player.method_5715()) {
            if (!world.field_9236) {
                boolean isOpen = (Boolean)state.method_11654((class_2769)OPEN);
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(!isOpen)));
                world.method_8396(null, pos, class_3417.field_42579, class_3419.field_15245, 1.0f, 2.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Nullable
    public static class_1767 getColor(class_2248 block) {
        return block instanceof JarBlock ? ((JarBlock)block).getColor() : null;
    }

    public static class_2248 get(@Nullable class_1767 dyeColor) {
        if (dyeColor == null) {
            return ModBlocks.JAR;
        }
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> ModBlocks.WHITE_JAR;
            case class_1767.field_7946 -> ModBlocks.ORANGE_JAR;
            case class_1767.field_7958 -> ModBlocks.MAGENTA_JAR;
            case class_1767.field_7951 -> ModBlocks.LIGHT_BLUE_JAR;
            case class_1767.field_7947 -> ModBlocks.YELLOW_JAR;
            case class_1767.field_7961 -> ModBlocks.LIME_JAR;
            case class_1767.field_7954 -> ModBlocks.PINK_JAR;
            case class_1767.field_7944 -> ModBlocks.GRAY_JAR;
            case class_1767.field_7967 -> ModBlocks.LIGHT_GRAY_JAR;
            case class_1767.field_7955 -> ModBlocks.CYAN_JAR;
            case class_1767.field_7966 -> ModBlocks.BLUE_JAR;
            case class_1767.field_7957 -> ModBlocks.BROWN_JAR;
            case class_1767.field_7942 -> ModBlocks.GREEN_JAR;
            case class_1767.field_7964 -> ModBlocks.RED_JAR;
            case class_1767.field_7963 -> ModBlocks.BLACK_JAR;
            case class_1767.field_7945 -> ModBlocks.PURPLE_JAR;
        };
    }

    @Nullable
    public class_1767 getColor() {
        return this.color;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!((Boolean)state.method_11654((class_2769)OPEN)).booleanValue()) {
            return CLOSED_SHAPE;
        }
        return OPEN_SHAPE;
    }

    protected boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Override
    @Nullable
    public class_2586 getBlockEntity(class_1937 world, class_2338 pos) {
        return world.method_8321(pos);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? JarBlock.method_31618(type, ModBlockEntities.JAR_BE, JarBlockEntity::tick) : null;
    }
}

