/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.custom.decorative;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.edu.resprouted.block.ModBlockEntities;
import net.edu.resprouted.block.entity.custom.decorative.LiquidBarrelBlockEntity;
import net.edu.resprouted.block.interfaces.LuminousFluidStorage;
import net.edu.resprouted.util.block.BlockUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5689;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class LiquidBarrelBlock
extends class_2237
implements LuminousFluidStorage,
class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (class_265[])new class_265[]{class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)4.0), class_2248.method_9541((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0), class_2248.method_9541((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0), class_2248.method_9541((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0)});
    private static final class_265 COLLISION = class_259.method_17786((class_265)class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (class_265[])new class_265[]{class_2248.method_9541((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)2.5), class_2248.method_9541((double)2.0, (double)1.0, (double)13.5, (double)14.0, (double)16.0, (double)14.0), class_2248.method_9541((double)13.5, (double)1.0, (double)2.5, (double)14.0, (double)16.0, (double)13.5), class_2248.method_9541((double)2.0, (double)1.0, (double)2.5, (double)2.5, (double)16.0, (double)13.5)});
    public static final MapCodec<LiquidBarrelBlock> CODEC = LiquidBarrelBlock.method_54094(LiquidBarrelBlock::new);

    public LiquidBarrelBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT_LEVEL, WATERLOGGED});
    }

    @Override
    @Nullable
    public class_2586 getBlockEntity(class_1937 world, class_2338 pos) {
        return world.method_8321(pos);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LiquidBarrelBlockEntity(pos, state);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        BlockUtils.appendFluidTooltip(stack, tooltip);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LiquidBarrelBlockEntity) {
            LiquidBarrelBlockEntity barrel = (LiquidBarrelBlockEntity)blockEntity;
            if (!world.field_9236 && player.method_7337() && !barrel.getFluidStorage().isResourceBlank()) {
                class_1799 stack = new class_1799((class_1935)this);
                stack.method_57365(barrel.method_57590());
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof LiquidBarrelBlockEntity) {
            LiquidBarrelBlockEntity barrel = (LiquidBarrelBlockEntity)blockEntity;
            class_1799 stack = new class_1799((class_1935)this);
            stack.method_57365(barrel.method_57590());
            return List.of(stack);
        }
        return List.of(new class_1799((class_1935)this));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world.field_9236 || !entity.method_5809()) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof LiquidBarrelBlockEntity) {
            LiquidBarrelBlockEntity barrel = (LiquidBarrelBlockEntity)class_25862;
            FluidVariant fluid = (FluidVariant)barrel.getFluidStorage().getResource();
            long amount = barrel.getFluidStorage().getAmount();
            if (!fluid.isBlank() && amount >= 27000L && this.isEntityTouchingFluid(pos, entity, barrel) && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_5646();
                world.method_20290(1009, pos, 0);
            }
        }
    }

    private boolean isEntityTouchingFluid(class_2338 pos, class_1297 entity, LiquidBarrelBlockEntity barrel) {
        class_238 entityBox = entity.method_5829();
        double fluidHeight = (double)pos.method_10264() + this.getFluidHeight(barrel);
        if (entity.method_23318() >= fluidHeight || entityBox.field_1325 <= (double)pos.method_10264() + 0.0625) {
            return false;
        }
        double interiorMin = 0.25;
        double interiorMax = 0.75;
        return entityBox.field_1320 > (double)pos.method_10263() + interiorMin && entityBox.field_1323 < (double)pos.method_10263() + interiorMax && entityBox.field_1324 > (double)pos.method_10260() + interiorMin && entityBox.field_1321 < (double)pos.method_10260() + interiorMax;
    }

    private double getFluidHeight(LiquidBarrelBlockEntity barrel) {
        long amount = barrel.getFluidStorage().getAmount();
        if (amount <= 0L) {
            return 0.0625;
        }
        long capacity = barrel.getFluidStorage().getCapacity();
        double fillPercentage = (double)amount / (double)capacity;
        return 0.0625 + 0.8125 * fillPercentage;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862;
        class_3611 fluid;
        class_2338 dripPos = class_5689.method_32767((class_1937)world, (class_2338)pos);
        if (dripPos != null && (fluid = class_5689.method_32775((class_3218)world, (class_2338)dripPos)) != class_3612.field_15906 && BlockUtils.canBeFilledByDripstone(fluid) && (class_25862 = world.method_8321(pos)) instanceof LiquidBarrelBlockEntity) {
            LiquidBarrelBlockEntity barrel = (LiquidBarrelBlockEntity)class_25862;
            BlockUtils.fillFromDripstone(state, (class_1937)world, pos, fluid, barrel.getFluidStorage(), this);
        }
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof LiquidBarrelBlockEntity) {
            LiquidBarrelBlockEntity barrel = (LiquidBarrelBlockEntity)class_25862;
            BlockUtils.handlePrecipitation(state, world, pos, precipitation, barrel.getFluidStorage(), this);
        }
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            return class_9062.field_47731;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof LiquidBarrelBlockEntity)) {
            return class_9062.field_47733;
        }
        return BlockUtils.handleFluidInteraction(world, pos, player, hand, hit, this, state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? LiquidBarrelBlock.method_31618(type, ModBlockEntities.LIQUID_BARREL_BE, LiquidBarrelBlockEntity::tick) : null;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION;
    }
}

