/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.entity.custom.agriculture;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.edu.resprouted.Resprouted;
import net.edu.resprouted.block.ModBlockEntities;
import net.edu.resprouted.block.interfaces.ImplementedInventory;
import net.edu.resprouted.item.custom.BoozeBottleItem;
import net.edu.resprouted.recipe.custom.BrewingBarrelRecipe;
import net.edu.resprouted.screen.custom.BrewingBarrelScreenHandler;
import net.edu.resprouted.util.fluid.FluidUtils;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BrewingBarrelBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    public static final int INPUT_IN_SLOT = 0;
    public static final int OUTPUT_IN_SLOT = 1;
    public static final int AUX_IN_SLOT = 2;
    public static final int INPUT_OUT_SLOT = 3;
    public static final int OUTPUT_OUT_SLOT = 4;
    public static final int AUX_OUT_SLOT = 5;
    protected final class_3913 propertyDelegate;
    protected int progress = 0;
    protected int maxProgress;
    private int inputQuality;
    private int outputQuality;
    private final SingleFluidStorage input;
    private final SingleFluidStorage output;
    private final SingleFluidStorage auxiliary;

    public BrewingBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BREWING_BARREL_BE, pos, state);
        this.maxProgress = Resprouted.COMMON_CONFIG.brewing.getMaxBrewTime();
        this.inputQuality = 0;
        this.outputQuality = 0;
        this.input = SingleFluidStorage.withFixedCapacity((long)648000L, this::update);
        this.output = SingleFluidStorage.withFixedCapacity((long)648000L, this::update);
        this.auxiliary = SingleFluidStorage.withFixedCapacity((long)81000L, this::update);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> BrewingBarrelBlockEntity.this.progress;
                    case 1 -> BrewingBarrelBlockEntity.this.maxProgress;
                    case 2 -> BrewingBarrelBlockEntity.this.inputQuality;
                    case 3 -> BrewingBarrelBlockEntity.this.outputQuality;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        BrewingBarrelBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        BrewingBarrelBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        BrewingBarrelBlockEntity.this.inputQuality = value;
                        break;
                    }
                    case 3: {
                        BrewingBarrelBlockEntity.this.outputQuality = value;
                    }
                }
            }

            public int method_17389() {
                return 4;
            }
        };
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("brewing.progress", this.progress);
        nbt.method_10569("brewing.max_progress", this.maxProgress);
        nbt.method_10569("brewing.inputquality", this.inputQuality);
        nbt.method_10569("brewing.outputquality", this.outputQuality);
        class_2487 inputFluidNbt = new class_2487();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.input, (Codec)FluidVariant.CODEC, (class_2487)inputFluidNbt, (class_7225.class_7874)registryLookup);
        nbt.method_10566("brewing.inputFluid", (class_2520)inputFluidNbt);
        class_2487 outputFluidNbt = new class_2487();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.output, (Codec)FluidVariant.CODEC, (class_2487)outputFluidNbt, (class_7225.class_7874)registryLookup);
        nbt.method_10566("brewing.outputFluid", (class_2520)outputFluidNbt);
        class_2487 auxiliaryFluidNbt = new class_2487();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.auxiliary, (Codec)FluidVariant.CODEC, (class_2487)auxiliaryFluidNbt, (class_7225.class_7874)registryLookup);
        nbt.method_10566("brewing.auxiliaryFluid", (class_2520)auxiliaryFluidNbt);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("brewing.progress");
        this.maxProgress = nbt.method_10550("brewing.max_progress");
        this.inputQuality = nbt.method_10550("brewing.primerquality");
        this.outputQuality = nbt.method_10550("brewing.outputquality");
        if (nbt.method_10573("brewing.inputFluid", 10)) {
            SingleVariantStorage.readNbt((SingleVariantStorage)this.input, (Codec)FluidVariant.CODEC, FluidVariant::blank, (class_2487)nbt.method_10562("brewing.inputFluid"), (class_7225.class_7874)registryLookup);
        }
        if (nbt.method_10573("brewing.outputFluid", 10)) {
            SingleVariantStorage.readNbt((SingleVariantStorage)this.output, (Codec)FluidVariant.CODEC, FluidVariant::blank, (class_2487)nbt.method_10562("brewing.outputFluid"), (class_7225.class_7874)registryLookup);
        }
        if (nbt.method_10573("brewing.auxiliaryFluid", 10)) {
            SingleVariantStorage.readNbt((SingleVariantStorage)this.auxiliary, (Codec)FluidVariant.CODEC, FluidVariant::blank, (class_2487)nbt.method_10562("brewing.auxiliaryFluid"), (class_7225.class_7874)registryLookup);
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        class_2487 inputFluidNbt = new class_2487();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.input, (Codec)FluidVariant.CODEC, (class_2487)inputFluidNbt, (class_7225.class_7874)registryLookup);
        nbt.method_10566("brewing.inputFluid", (class_2520)inputFluidNbt);
        class_2487 outputFluidNbt = new class_2487();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.output, (Codec)FluidVariant.CODEC, (class_2487)outputFluidNbt, (class_7225.class_7874)registryLookup);
        nbt.method_10566("brewing.outputFluid", (class_2520)outputFluidNbt);
        class_2487 auxiliaryFluidNbt = new class_2487();
        SingleVariantStorage.writeNbt((SingleVariantStorage)this.auxiliary, (Codec)FluidVariant.CODEC, (class_2487)auxiliaryFluidNbt, (class_7225.class_7874)registryLookup);
        nbt.method_10566("brewing.auxiliaryFluid", (class_2520)auxiliaryFluidNbt);
        return nbt;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BrewingBarrelScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    private void update() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public SingleFluidStorage getInputTank() {
        return this.input;
    }

    public SingleFluidStorage getOutputTank() {
        return this.output;
    }

    public SingleFluidStorage getAuxiliaryTank() {
        return this.auxiliary;
    }

    public static void tick(class_1937 world, BrewingBarrelBlockEntity blockEntity) {
        if (world.method_8608()) {
            return;
        }
        blockEntity.maxProgress = Resprouted.COMMON_CONFIG.brewing.getMaxBrewTime();
        blockEntity.handleBucketInteractions();
        blockEntity.handleBottleInteractions();
        blockEntity.handleOutputBottleInteractions();
        blockEntity.tryCraft();
    }

    public void handleBucketInteractions() {
        class_1799 i = this.method_5438(0);
        class_1799 j = this.method_5438(3);
        boolean isInsertingEmptyBucket = i.method_31574(class_1802.field_8550);
        if (!j.method_7960() && isInsertingEmptyBucket) {
            return;
        }
        if (i.method_7960()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            class_1792 filledBucket;
            long amount;
            FluidVariant currentFluid;
            class_3611 fluid;
            if (i.method_7909() instanceof class_1755 && i.method_7909() != class_1802.field_8550 && (fluid = this.getFluidFromBucket(i)) != class_3612.field_15906) {
                FluidVariant variant = FluidVariant.of((class_3611)fluid);
                long amount2 = 81000L;
                if ((this.input.isResourceBlank() || ((FluidVariant)this.input.getResource()).isOf((Object)fluid)) && this.input.insert((TransferVariant)variant, amount2, (TransactionContext)transaction) == amount2) {
                    class_1799 currentOutput;
                    i.method_7934(1);
                    if (i.method_7960()) {
                        this.method_5447(0, class_1799.field_8037);
                    }
                    if ((currentOutput = this.method_5438(3)).method_7960()) {
                        this.method_5447(3, new class_1799((class_1935)class_1802.field_8550));
                    } else if (currentOutput.method_31574(class_1802.field_8550) && currentOutput.method_7947() < currentOutput.method_7914()) {
                        currentOutput.method_7933(1);
                        this.method_5447(3, currentOutput);
                    } else {
                        return;
                    }
                    transaction.commit();
                    this.method_5431();
                    return;
                }
            }
            if (i.method_31574(class_1802.field_8550) && !this.input.isResourceBlank() && this.input.extract((TransferVariant)(currentFluid = (FluidVariant)this.input.getResource()), amount = 81000L, (TransactionContext)transaction) == amount && (filledBucket = currentFluid.getFluid().method_15774()) != null && filledBucket != class_1802.field_8162) {
                i.method_7934(1);
                if (i.method_7960()) {
                    this.method_5447(0, class_1799.field_8037);
                }
                this.method_5447(3, new class_1799((class_1935)filledBucket));
                transaction.commit();
                this.method_5431();
            }
        }
    }

    private class_3611 getFluidFromBucket(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8705)) {
            return class_3612.field_15910;
        }
        if (stack.method_31574(class_1802.field_8187)) {
            return class_3612.field_15908;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1755) {
            for (class_3611 fluid : class_7923.field_41173) {
                if (fluid.method_15774() != item) continue;
                return fluid;
            }
        }
        return class_3612.field_15906;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleBottleInteractions() {
        Transaction t;
        class_1799 k = this.method_5438(2);
        class_1792 class_17922 = k.method_7909();
        if (class_17922 instanceof BoozeBottleItem) {
            BoozeBottleItem boozeBottle = (BoozeBottleItem)class_17922;
            t = Transaction.openOuter();
            try {
                class_1799 l;
                FluidVariant fluidFromBottle = boozeBottle.toFluidVariant(k);
                long amount = 81000L;
                if (!this.auxiliary.isResourceBlank() && !((FluidVariant)this.auxiliary.getResource()).equals((Object)fluidFromBottle) || this.auxiliary.insert((TransferVariant)fluidFromBottle, amount, (TransactionContext)t) != amount) return;
                k.method_7934(1);
                if (k.method_7960()) {
                    this.method_5447(2, class_1799.field_8037);
                }
                if ((l = this.method_5438(5)).method_7960()) {
                    this.method_5447(5, new class_1799((class_1935)class_1802.field_8469));
                } else {
                    if (!l.method_31574(class_1802.field_8469) || l.method_7947() >= l.method_7914()) return;
                    l.method_7933(1);
                    this.method_5447(5, l);
                }
                t.commit();
                this.method_5431();
                return;
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        if (!k.method_31574(class_1802.field_8469) || this.auxiliary.isResourceBlank()) return;
        t = Transaction.openOuter();
        try {
            class_1799 currentAuxOutput;
            class_1799 filledBottle;
            FluidVariant currentFluid = (FluidVariant)this.auxiliary.getResource();
            long amount = 81000L;
            if (this.auxiliary.extract((TransferVariant)currentFluid, amount, (TransactionContext)t) != amount || (filledBottle = BoozeBottleItem.fromFluidVariant(currentFluid)).method_7960()) return;
            k.method_7934(1);
            if (k.method_7960()) {
                this.method_5447(2, class_1799.field_8037);
            }
            if ((currentAuxOutput = this.method_5438(5)).method_7960()) {
                this.method_5447(5, filledBottle);
            } else {
                if (currentAuxOutput.method_7909() != filledBottle.method_7909() || BoozeBottleItem.getQuality(currentAuxOutput) != BoozeBottleItem.getQuality(filledBottle) || currentAuxOutput.method_7947() >= currentAuxOutput.method_7914()) return;
                currentAuxOutput.method_7933(1);
                this.method_5447(5, currentAuxOutput);
            }
            t.commit();
            this.method_5431();
            return;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    public void handleOutputBottleInteractions() {
        class_1799 m = this.method_5438(1);
        class_1799 n = this.method_5438(4);
        if (!m.method_31574(class_1802.field_8469) || this.output.isResourceBlank()) {
            return;
        }
        if (!n.method_7960() && ((FluidVariant)this.output.getResource()).getFluid() != BoozeBottleItem.getFluidFromBottle(n)) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            FluidVariant variant = (FluidVariant)this.output.getResource();
            long amount = 81000L;
            if (this.output.extract((TransferVariant)variant, amount, (TransactionContext)t) == amount) {
                class_1799 bottle = BoozeBottleItem.fromFluidVariant(variant);
                if (bottle.method_7960()) {
                    return;
                }
                if (!(n.method_7960() || n.method_7909() == bottle.method_7909() && BoozeBottleItem.getQuality(n) == BoozeBottleItem.getQuality(bottle) && n.method_7947() < n.method_7914())) {
                    return;
                }
                m.method_7934(1);
                if (m.method_7960()) {
                    this.method_5447(1, class_1799.field_8037);
                }
                if (n.method_7960()) {
                    this.method_5447(4, bottle);
                } else {
                    n.method_7933(1);
                    this.method_5447(4, n);
                }
                t.commit();
                this.method_5431();
            }
        }
    }

    public void tryCraft() {
        long auxAmount;
        FluidVariant auxVariant;
        long inputAmount;
        if (this.field_11863 == null) {
            return;
        }
        FluidVariant inputVariant = (FluidVariant)this.input.getResource();
        Optional<BrewingBarrelRecipe> recipeOpt = BrewingBarrelRecipe.findMatchingRecipe(inputVariant, inputAmount = this.input.getAmount(), auxVariant = (FluidVariant)this.auxiliary.getResource(), auxAmount = this.auxiliary.getAmount());
        if (recipeOpt.isPresent() && this.canCraft()) {
            ++this.progress;
            if (this.progress >= this.maxProgress) {
                this.craft(recipeOpt.get(), inputVariant, inputAmount, auxVariant, auxAmount);
                this.progress = 0;
            }
            this.method_5431();
        } else if (this.progress != 0) {
            this.progress = 0;
            this.method_5431();
        }
    }

    private boolean canCraft() {
        return this.input.getAmount() > 0L && this.output.getAmount() < this.output.getCapacity();
    }

    private void craft(BrewingBarrelRecipe recipe, FluidVariant inputVariant, long inputAmount, FluidVariant auxVariant, long auxAmount) {
        try (Transaction t = Transaction.openOuter();){
            long availableSpace = this.output.getCapacity() - this.output.getAmount();
            long amountToConvert = Math.min(availableSpace, inputAmount);
            if (amountToConvert <= 0L) {
                return;
            }
            this.input.extract((TransferVariant)inputVariant, amountToConvert, (TransactionContext)t);
            assert (this.field_11863 != null);
            FluidVariant newResult = recipe.getResult(inputVariant, inputAmount, auxVariant, auxAmount, this.field_11863.field_9229);
            if (newResult != null && !newResult.isBlank()) {
                if (!this.output.isResourceBlank() && ((FluidVariant)this.output.getResource()).isOf((Object)newResult.getFluid())) {
                    float existingQuality = FluidUtils.getQuality((FluidVariant)this.output.getResource());
                    newResult = FluidUtils.withQuality(newResult, existingQuality);
                }
                this.output.insert((TransferVariant)newResult, amountToConvert, (TransactionContext)t);
            }
            t.commit();
            this.method_5431();
        }
    }
}

