/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.entity.custom.agriculture;

import java.util.Optional;
import net.edu.resprouted.block.ModBlockEntities;
import net.edu.resprouted.block.abstracts.entity.AbstractAnimatedSingleFluidStorageBlockEntity;
import net.edu.resprouted.block.interfaces.ImplementedInventory;
import net.edu.resprouted.recipe.Input.DryingBasinRecipeInput;
import net.edu.resprouted.recipe.ModRecipes;
import net.edu.resprouted.recipe.custom.DryingBasinRecipe;
import net.edu.resprouted.util.misc.ModTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class DryingBasinBlockEntity
extends AbstractAnimatedSingleFluidStorageBlockEntity
implements ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private static final long DRYING_BOOSTER = 2L;
    private int progress = 0;

    public DryingBasinBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.DRYING_BASIN_BE, pos, state, 162000L);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("drying_basin.progress", this.progress);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.clear();
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("drying_basin.progress");
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, DryingBasinBlockEntity entity) {
        entity.tickFluidAnimation();
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, DryingBasinBlockEntity be) {
        FluidVariant fluid = (FluidVariant)be.getFluidStorage().getResource();
        long amt = be.getFluidStorage().getAmount();
        if (fluid.isBlank() || amt == 0L) {
            be.progress = 0;
            return;
        }
        class_1799 storedItem = (class_1799)be.inventory.getFirst();
        DryingBasinRecipeInput in = new DryingBasinRecipeInput(fluid, amt, storedItem);
        Optional<class_8786> opt = world.method_8433().method_30027(ModRecipes.DRYING_TYPE).stream().filter(e -> ((DryingBasinRecipe)e.comp_1933()).matches(in, world)).findFirst();
        if (opt.isEmpty()) {
            be.progress = 0;
            return;
        }
        DryingBasinRecipe recipe = (DryingBasinRecipe)opt.get().comp_1933();
        class_2338 below = pos.method_10074();
        class_2680 belowState = world.method_8320(below);
        boolean boosted = belowState.method_26164(ModTags.Blocks.DRYING_BOOSTERS) || belowState.method_26204() instanceof class_3922 && (Boolean)belowState.method_11654((class_2769)class_3922.field_17352) != false;
        int tickIncrement = boosted ? 2 : 1;
        be.progress += tickIncrement;
        int craftTime = recipe.craftTime();
        if (be.progress >= craftTime) {
            try (Transaction tx = Transaction.openOuter();){
                long extracted = be.getFluidStorage().extract((TransferVariant)fluid, recipe.fluidCost(), (TransactionContext)tx);
                if (extracted == recipe.fluidCost()) {
                    tx.commit();
                    be.progress = 0;
                    be.spawnOrStore(recipe.output().method_7972());
                    world.method_8396(null, pos, class_3417.field_49173, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_8413(pos, state, state, 2);
                } else {
                    be.progress = 0;
                }
            }
        }
        be.method_5431();
    }

    private void spawnOrStore(class_1799 stack) {
        class_1799 slot = (class_1799)this.inventory.getFirst();
        if (slot.method_7960()) {
            this.inventory.set(0, (Object)stack);
        } else if (class_1799.method_31577((class_1799)slot, (class_1799)stack) && slot.method_7947() + stack.method_7947() <= slot.method_7914()) {
            slot.method_7933(stack.method_7947());
        } else {
            assert (this.field_11863 != null);
            class_1264.method_17349((class_1937)this.field_11863, (class_2338)this.field_11867, (class_2371)class_2371.method_10213((int)1, (Object)stack));
        }
        this.method_5431();
    }
}

