/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.block.entity.renderer;

import java.util.Random;
import net.edu.resprouted.block.entity.custom.agriculture.CrushingTubBlockEntity;
import net.edu.resprouted.util.misc.ModTags;
import net.edu.resprouted.util.render.RenderUtils;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class CrushingTubBlockEntityRenderer
implements class_827<CrushingTubBlockEntity> {
    public CrushingTubBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(CrushingTubBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (!entity.method_5438(0).method_7960()) {
            this.renderItems(entity, matrices, vertexConsumers);
        }
        FluidVariant fluid = (FluidVariant)entity.getFluidStorage().getResource();
        long amount = entity.getFluidStorage().getAmount();
        if (!fluid.isBlank() && amount > 0L) {
            float fillPercentage = entity.getFluidHeight(tickDelta);
            int color = FluidVariantRendering.getColor((FluidVariant)fluid, (class_1920)entity.method_10997(), (class_2338)entity.method_11016());
            class_1058 sprite = RenderUtils.getFluidSprite(fluid);
            class_1921 renderLayer = class_4696.method_23680((class_3610)fluid.getFluid().method_15785());
            class_4588 buffer = vertexConsumers.getBuffer(renderLayer);
            float BASE_HEIGHT = 0.0625f;
            float MAX_FILL_HEIGHT = 0.5f;
            float Z_OFFSET = 5.0E-4f;
            float MIN_XZ = 0.125f;
            float MAX_XZ = 0.875f;
            float fluidHeight = 0.0625f + fillPercentage * 0.5f - 5.0E-4f;
            RenderUtils.renderFluidQuad(matrices, buffer, sprite, color, fluidHeight, 0.125f, 0.875f, 0.125f, 0.875f, light);
        }
    }

    private void renderItems(CrushingTubBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers) {
        class_1799 stack = entity.method_5438(0);
        class_918 itemRenderer = class_310.method_1551().method_1480();
        Random random = new Random(entity.method_11016().method_10063());
        int light = this.getLightLevel(entity.method_10997(), entity.method_11016());
        int itemCount = stack.method_7947();
        boolean isBlockItem = stack.method_7909() instanceof class_1747;
        boolean useVerticalRender = false;
        if (isBlockItem) {
            class_2248 block = ((class_1747)stack.method_7909()).method_7711();
            useVerticalRender = block.method_9564().method_26164(ModTags.Blocks.DIFFERENT_TUB_RENDER);
        }
        matrices.method_22903();
        if (useVerticalRender) {
            float PIXEL = 0.0625f;
            float SCALE_FACTOR = 0.53f;
            float BLOCK_SCALE = 0.55f;
            int ITEMS_PER_LAYER = 16;
            float startHeight = 0.14156249f;
            matrices.method_46416(0.5f, startHeight, 0.5f);
            float initialOffsetX = (random.nextFloat() - 0.5f) / 4.0f;
            float initialOffsetZ = (random.nextFloat() - 0.5f) / 4.0f;
            matrices.method_46416(initialOffsetX, 0.0f, initialOffsetZ);
            matrices.method_22905(0.55f, 0.55f, 0.55f);
            class_1087 model = itemRenderer.method_4019(stack, entity.method_10997(), null, 0);
            for (int i = 0; i < itemCount; ++i) {
                if (i % 16 != 0) continue;
                float layerOffsetX = (random.nextFloat() - 0.5f) / 4.0f;
                float layerOffsetZ = (random.nextFloat() - 0.5f) / 4.0f;
                float layerSpacing = 0.22727272f;
                matrices.method_46416(layerOffsetX, layerSpacing, layerOffsetZ);
                itemRenderer.method_23179(stack, class_811.field_4315, false, matrices, vertexConsumers, light, class_4608.field_21444, model);
            }
        } else {
            float ITEM_SCALE = 0.55f;
            float BASE_HEIGHT = 0.1f;
            float Z_OFFSET = 0.002f;
            float LAYER_SPACING = 0.05f;
            int MAX_LAYERS = 16;
            matrices.method_46416(0.5f, 0.1f, 0.502f);
            matrices.method_22905(0.55f, 0.55f, 0.55f);
            int renderLayers = Math.min(16, (int)Math.ceil((float)itemCount / 4.0f));
            float currentHeight = 0.0f;
            class_1087 model = itemRenderer.method_4019(stack, entity.method_10997(), null, 0);
            class_4588 cutoutBuffer = vertexConsumers.getBuffer(class_1921.method_23581());
            for (int layer = 0; layer < renderLayers; ++layer) {
                matrices.method_22903();
                matrices.method_46416(0.0f, currentHeight, 0.0f);
                if (layer > 0) {
                    float scatterX = (random.nextFloat() - 0.5f) * 0.1f;
                    float scatterZ = (random.nextFloat() - 0.5f) * 0.1f;
                    float randomRotation = random.nextFloat() * 360.0f;
                    matrices.method_46416(scatterX, 0.0f, scatterZ);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(randomRotation));
                }
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                if (!(stack.method_7909() instanceof class_1747)) {
                    matrices.method_22907(class_7833.field_40718.rotationDegrees(45.0f));
                }
                itemRenderer.method_23179(stack, class_811.field_4317, false, matrices, renderLayer -> cutoutBuffer, light, class_4608.field_21444, model);
                matrices.method_22909();
                currentHeight += 0.05f;
            }
        }
        matrices.method_22909();
    }

    private int getLightLevel(class_1937 world, class_2338 pos) {
        if (world == null) {
            return 0xF000F0;
        }
        return class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos), (int)world.method_8314(class_1944.field_9284, pos));
    }
}

