/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.book;

import java.util.List;
import net.edu.resprouted.book.CatalogData;
import net.edu.resprouted.book.abstracts.BaseCatalogPage;
import net.edu.resprouted.book.pages.CategoryListPage;
import net.edu.resprouted.book.pages.EntryPagesPage;
import net.edu.resprouted.book.pages.MainMenuPage;
import net.edu.resprouted.networking.payload.RemoveCatalogModelPayload;
import net.edu.resprouted.util.misc.PageUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class CatalogScreen
extends class_437 {
    public static final class_2960 BACKGROUND = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/book.png");
    public static final int BOOK_WIDTH = 293;
    public static final int BOOK_HEIGHT = 184;
    public static final int TEXTURE_SIZE = 512;
    private PageState currentState = PageState.MAIN_MENU;
    private PageState previousState = null;
    private CatalogData.Category selectedCategory;
    private CatalogData.Entry selectedEntry;
    private int currentPageIndex = 0;
    private int bookX;
    private int bookY;
    private MainMenuPage mainMenuPage;
    private CategoryListPage categoryListPage;
    private EntryPagesPage entryPagesPage;

    public CatalogScreen() {
        super((class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        super.method_25426();
        this.bookX = (this.field_22789 - 293) / 2;
        this.bookY = (this.field_22790 - 184) / 2;
        this.mainMenuPage = new MainMenuPage(this);
        this.categoryListPage = new CategoryListPage(this);
        this.entryPagesPage = new EntryPagesPage(this);
        this.updatePageWidgets();
    }

    public void method_25419() {
        super.method_25419();
        ClientPlayNetworking.send((class_8710)new RemoveCatalogModelPayload());
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_52752(context);
        context.method_25290(BACKGROUND, this.bookX, this.bookY, 0.0f, 0.0f, 293, 184, 512, 512);
        PageUtils leftPage = PageUtils.createLeftPage(context, this.getTextRenderer(), this.bookX, this.bookY);
        PageUtils rightPage = PageUtils.createRightPage(context, this.getTextRenderer(), this.bookX, this.bookY);
        this.getCurrentPage().render(leftPage, rightPage, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        for (class_364 child : this.method_25396()) {
            if (!child.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.getCurrentPage().handleClick(mouseX, mouseY) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 263: {
                if (this.currentState != PageState.ENTRY_PAGES || this.currentPageIndex <= 0) break;
                --this.currentPageIndex;
                this.playPageTurnSound();
                return true;
            }
            case 262: {
                if (this.currentState != PageState.ENTRY_PAGES || this.selectedEntry == null || this.currentPageIndex >= this.selectedEntry.getPages().size() - 1) break;
                ++this.currentPageIndex;
                this.playPageTurnSound();
                return true;
            }
            case 265: {
                if (this.currentState != PageState.ENTRY_PAGES) break;
                this.currentState = PageState.CATEGORY_LIST;
                this.selectedEntry = null;
                this.playPageTurnSound();
                this.updatePageWidgets();
                return true;
            }
            case 264: {
                if (this.currentState != PageState.ENTRY_PAGES && this.currentState != PageState.CATEGORY_LIST) break;
                this.currentState = PageState.MAIN_MENU;
                this.selectedEntry = null;
                this.selectedCategory = null;
                this.playPageTurnSound();
                this.updatePageWidgets();
                return true;
            }
            case 258: {
                if (this.currentState != PageState.MAIN_MENU && this.currentState != PageState.CATEGORY_LIST) break;
                return this.navigateCategories(modifiers == 1);
            }
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    private boolean navigateCategories(boolean reverse) {
        List<CatalogData.Category> categories = CatalogData.CATEGORIES;
        if (categories.isEmpty()) {
            return false;
        }
        if (this.selectedCategory == null) {
            this.selectedCategory = categories.getFirst();
            this.currentState = PageState.CATEGORY_LIST;
            this.selectedEntry = null;
            this.playPageTurnSound();
            this.updatePageWidgets();
            return true;
        }
        int currentIndex = categories.indexOf(this.selectedCategory);
        int newIndex = reverse ? (currentIndex <= 0 ? categories.size() - 1 : currentIndex - 1) : (currentIndex >= categories.size() - 1 ? 0 : currentIndex + 1);
        this.selectedCategory = categories.get(newIndex);
        this.selectedEntry = null;
        this.playPageTurnSound();
        return true;
    }

    private void updatePageWidgets() {
        if (this.currentState == this.previousState) {
            return;
        }
        this.method_37067();
        BaseCatalogPage page = this.getCurrentPage();
        page.init();
        page.getWidgets().forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.previousState = this.currentState;
    }

    private BaseCatalogPage getCurrentPage() {
        return switch (this.currentState.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.mainMenuPage;
            case 1 -> this.categoryListPage;
            case 2 -> this.entryPagesPage;
        };
    }

    public void playPageTurnSound() {
        if (this.field_22787 != null && this.field_22787.method_1483() != null) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public class_327 getTextRenderer() {
        return this.field_22793;
    }

    public PageState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(PageState state) {
        if (this.currentState != state) {
            this.currentState = state;
            this.updatePageWidgets();
        }
    }

    public CatalogData.Category getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(CatalogData.Category category) {
        this.selectedCategory = category;
        if (this.categoryListPage != null) {
            this.categoryListPage.resetPage();
        }
    }

    public CatalogData.Entry getSelectedEntry() {
        return this.selectedEntry;
    }

    public void setSelectedEntry(CatalogData.Entry entry) {
        this.selectedEntry = entry;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int index) {
        this.currentPageIndex = index;
    }

    public int getBookX() {
        return this.bookX;
    }

    public int getBookY() {
        return this.bookY;
    }

    public static enum PageState {
        MAIN_MENU,
        CATEGORY_LIST,
        ENTRY_PAGES;

    }
}

