/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.book.pages;

import java.util.ArrayList;
import java.util.List;
import net.edu.resprouted.book.CatalogData;
import net.edu.resprouted.book.CatalogScreen;
import net.edu.resprouted.book.abstracts.BaseCatalogPage;
import net.edu.resprouted.util.misc.PageUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;

@Environment(value=EnvType.CLIENT)
public class CategoryListPage
extends BaseCatalogPage {
    private static final class_2960 PREV_BUTTON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/previous_page.png");
    private static final class_2960 NEXT_BUTTON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/next_page.png");
    private static final int ENTRY_START_Y_LEFT = 30;
    private static final int ENTRY_START_Y_RIGHT = 10;
    private static final int ENTRY_SPACING = 17;
    private static final int ENTRY_WIDTH = 112;
    private static final int ENTRY_HEIGHT = 16;
    private static final int MAX_ENTRIES_LEFT = 7;
    private static final int MAX_ENTRIES_RIGHT = 8;
    private int currentCategoryPageIndex = 0;
    private List<PageLayout> cachedLayouts = new ArrayList<PageLayout>();

    public CategoryListPage(CatalogScreen screen) {
        super(screen);
    }

    @Override
    public void init() {
        super.init();
        int bookX = this.screen.getBookX();
        int bookY = this.screen.getBookY();
        this.currentCategoryPageIndex = 0;
        this.widgets.add(this.createNavigationButton(PREV_BUTTON, bookX + 10, bookY + 148, 13, 15, (class_2561)class_2561.method_43471((String)"text.resprouted.previous_page"), button -> {
            if (this.currentCategoryPageIndex > 0) {
                --this.currentCategoryPageIndex;
                this.screen.playPageTurnSound();
            }
        }));
        this.widgets.add(this.createNavigationButton(NEXT_BUTTON, bookX + 268, bookY + 148, 13, 15, (class_2561)class_2561.method_43471((String)"text.resprouted.next_page"), button -> {
            if (this.currentCategoryPageIndex < this.cachedLayouts.size() - 1) {
                ++this.currentCategoryPageIndex;
                this.screen.playPageTurnSound();
            }
        }));
        this.widgets.add(this.createMenuButton(bookX, bookY));
    }

    @Override
    public void render(PageUtils leftPage, PageUtils rightPage, int mouseX, int mouseY) {
        CatalogData.Category selectedCategory = this.screen.getSelectedCategory();
        if (selectedCategory == null) {
            return;
        }
        leftPage.drawTitle((class_2561)class_2561.method_43471((String)("text.category.resprouted." + selectedCategory.getName())).method_27692(class_124.field_1067), 10, 8549726);
        leftPage.drawIcon(SEPARATOR, 12, 22, 94, 3);
        this.cachedLayouts = this.calculatePageLayouts(selectedCategory.getEntries());
        if (this.currentCategoryPageIndex >= this.cachedLayouts.size()) {
            this.currentCategoryPageIndex = Math.max(0, this.cachedLayouts.size() - 1);
        }
        if (!this.cachedLayouts.isEmpty()) {
            PageLayout currentLayout = this.cachedLayouts.get(this.currentCategoryPageIndex);
            this.renderPageLayout(leftPage, rightPage, currentLayout, mouseX, mouseY);
        }
        this.updateButtonVisibility();
    }

    @Override
    public boolean handleClick(double mouseX, double mouseY) {
        if (this.cachedLayouts.isEmpty() || this.currentCategoryPageIndex >= this.cachedLayouts.size()) {
            return false;
        }
        PageLayout currentLayout = this.cachedLayouts.get(this.currentCategoryPageIndex);
        return this.handleLayoutClicks(currentLayout, mouseX, mouseY);
    }

    private List<PageLayout> calculatePageLayouts(List<CatalogData.Entry> allEntries) {
        ArrayList<PageLayout> layouts = new ArrayList<PageLayout>();
        PageLayout currentPage = new PageLayout();
        for (CatalogData.Entry entry : allEntries) {
            if (currentPage.leftEntries.size() < 7) {
                currentPage.leftEntries.add(entry);
                continue;
            }
            if (currentPage.rightEntries.size() < 8) {
                currentPage.rightEntries.add(entry);
                continue;
            }
            layouts.add(currentPage);
            currentPage = new PageLayout();
            currentPage.leftEntries.add(entry);
        }
        if (!currentPage.isEmpty()) {
            layouts.add(currentPage);
        }
        return layouts;
    }

    private void renderPageLayout(PageUtils leftPage, PageUtils rightPage, PageLayout layout, int mouseX, int mouseY) {
        int y;
        CatalogData.Entry entry;
        int i;
        for (i = 0; i < layout.leftEntries.size(); ++i) {
            entry = layout.leftEntries.get(i);
            y = 30 + i * 17;
            if (leftPage.isMouseOverEntry(mouseX, mouseY, y, 112, 16)) {
                this.drawEntryHoverBackground(leftPage, y, 112, 16);
            }
            leftPage.drawItemStackIcon(entry.getIcon(), 10, y);
            leftPage.drawText(entry.getName(), 30, y + 4, 8549726);
        }
        for (i = 0; i < layout.rightEntries.size(); ++i) {
            entry = layout.rightEntries.get(i);
            y = 10 + i * 17;
            if (rightPage.isMouseOverEntry(mouseX, mouseY, y, 112, 16)) {
                this.drawEntryHoverBackground(rightPage, y, 112, 16);
            }
            rightPage.drawItemStackIcon(entry.getIcon(), 10, y);
            rightPage.drawText(entry.getName(), 30, y + 4, 8549726);
        }
    }

    private boolean handleLayoutClicks(PageLayout layout, double mouseX, double mouseY) {
        int pageY;
        int y;
        int pageX;
        CatalogData.Entry entry;
        int i;
        int bookX = this.screen.getBookX();
        int bookY = this.screen.getBookY();
        for (i = 0; i < layout.leftEntries.size(); ++i) {
            entry = layout.leftEntries.get(i);
            pageX = bookX + 18 + 8;
            y = 30 + i * 17;
            pageY = bookY + 5 + y;
            if (!this.screen.isMouseOver(mouseX, mouseY, pageX, pageY, 112, 16)) continue;
            this.selectEntry(entry);
            return true;
        }
        for (i = 0; i < layout.rightEntries.size(); ++i) {
            entry = layout.rightEntries.get(i);
            pageX = bookX + 148 + 8;
            y = 10 + i * 17;
            pageY = bookY + 5 + y;
            if (!this.screen.isMouseOver(mouseX, mouseY, pageX, pageY, 112, 16)) continue;
            this.selectEntry(entry);
            return true;
        }
        return false;
    }

    private void selectEntry(CatalogData.Entry entry) {
        if (this.screen.getSelectedEntry() != entry || this.screen.getCurrentState() != CatalogScreen.PageState.ENTRY_PAGES) {
            this.screen.setSelectedEntry(entry);
            this.screen.setCurrentPageIndex(0);
            this.screen.setCurrentState(CatalogScreen.PageState.ENTRY_PAGES);
            this.screen.playPageTurnSound();
        }
    }

    private void updateButtonVisibility() {
        if (this.widgets.size() >= 3) {
            ((class_339)this.widgets.get((int)0)).field_22764 = this.currentCategoryPageIndex > 0;
            ((class_339)this.widgets.get((int)1)).field_22764 = this.currentCategoryPageIndex < this.cachedLayouts.size() - 1;
            ((class_339)this.widgets.get((int)2)).field_22764 = true;
        }
    }

    public void resetPage() {
        this.currentCategoryPageIndex = 0;
        this.cachedLayouts.clear();
    }

    private static class PageLayout {
        List<CatalogData.Entry> leftEntries = new ArrayList<CatalogData.Entry>();
        List<CatalogData.Entry> rightEntries = new ArrayList<CatalogData.Entry>();

        private PageLayout() {
        }

        boolean isEmpty() {
            return this.leftEntries.isEmpty() && this.rightEntries.isEmpty();
        }
    }
}

