/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.book.pages;

import java.util.List;
import net.edu.resprouted.book.CatalogData;
import net.edu.resprouted.book.CatalogScreen;
import net.edu.resprouted.book.abstracts.BaseCatalogPage;
import net.edu.resprouted.util.misc.PageUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;

public class EntryPagesPage
extends BaseCatalogPage {
    private static final class_2960 CATEGORY_ICON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/category_back.png");
    private static final class_2960 PREV_BUTTON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/previous_page.png");
    private static final class_2960 NEXT_BUTTON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/next_page.png");

    public EntryPagesPage(CatalogScreen screen) {
        super(screen);
    }

    @Override
    public void init() {
        super.init();
        int bookX = this.screen.getBookX();
        int bookY = this.screen.getBookY();
        this.widgets.add(this.createNavigationButton(PREV_BUTTON, bookX + 10, bookY + 148, 13, 15, (class_2561)class_2561.method_43471((String)"text.resprouted.previous_page"), button -> {
            int current = this.screen.getCurrentPageIndex();
            if (current > 0) {
                this.screen.setCurrentPageIndex(current - 1);
                this.screen.playPageTurnSound();
            }
        }));
        this.widgets.add(this.createNavigationButton(NEXT_BUTTON, bookX + 268, bookY + 148, 13, 15, (class_2561)class_2561.method_43471((String)"text.resprouted.next_page"), button -> {
            CatalogData.Entry entry = this.screen.getSelectedEntry();
            int current = this.screen.getCurrentPageIndex();
            if (entry != null && current < entry.getPages().size() - 1) {
                this.screen.setCurrentPageIndex(current + 1);
                this.screen.playPageTurnSound();
            }
        }));
        this.widgets.add(this.createNavigationButton(CATEGORY_ICON, bookX + 9, bookY + 5, 13, 15, (class_2561)class_2561.method_43471((String)"text.resprouted.back_category"), button -> {
            this.screen.setCurrentState(CatalogScreen.PageState.CATEGORY_LIST);
            this.screen.setSelectedEntry(null);
            this.screen.playPageTurnSound();
        }));
        this.widgets.add(this.createMenuButton(bookX, bookY));
    }

    @Override
    public void render(PageUtils leftPage, PageUtils rightPage, int mouseX, int mouseY) {
        CatalogData.Entry selectedEntry = this.screen.getSelectedEntry();
        if (selectedEntry == null) {
            return;
        }
        List<CatalogData.TextPage> pages = selectedEntry.getPages();
        int currentPageIndex = this.screen.getCurrentPageIndex();
        if (pages.isEmpty() || currentPageIndex >= pages.size()) {
            return;
        }
        CatalogData.TextPage page = pages.get(currentPageIndex);
        leftPage.drawTitle(selectedEntry.getName(), 10, 8549726);
        leftPage.drawIcon(SEPARATOR, 12, 22, 94, 3);
        leftPage.drawParagraph(page.getLeftText(), 30, 8549726);
        if (page.getRightText() != null) {
            rightPage.drawParagraph(page.getRightText(), 10, 8549726);
        }
        this.updateButtonVisibility();
    }

    @Override
    public boolean handleClick(double mouseX, double mouseY) {
        return false;
    }

    private void updateButtonVisibility() {
        CatalogData.Entry selectedEntry = this.screen.getSelectedEntry();
        int currentPageIndex = this.screen.getCurrentPageIndex();
        if (selectedEntry != null && this.widgets.size() >= 4) {
            ((class_339)this.widgets.get((int)0)).field_22764 = currentPageIndex > 0;
            ((class_339)this.widgets.get((int)1)).field_22764 = currentPageIndex < selectedEntry.getPages().size() - 1;
            ((class_339)this.widgets.get((int)2)).field_22764 = true;
            ((class_339)this.widgets.get((int)3)).field_22764 = true;
        }
    }
}

