/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.book.pages;

import java.util.List;
import net.edu.resprouted.book.CatalogData;
import net.edu.resprouted.book.CatalogScreen;
import net.edu.resprouted.book.abstracts.BaseCatalogPage;
import net.edu.resprouted.book.widget.AnimatedIconWidget;
import net.edu.resprouted.util.misc.PageUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class MainMenuPage
extends BaseCatalogPage {
    private static final class_2960 MENU_TITLE = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/menu_title.png");
    private static final class_2960 INDEX_TITLE = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/index_title.png");
    private static final class_2960 AGRICULTURE_ICON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/agriculture.png");
    private static final class_2960 DECORATION_ICON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/decoration.png");
    private static final class_2960 PRODUCTION_ICON = class_2960.method_60655((String)"resprouted", (String)"textures/gui/catalog/production.png");
    private static final int[] ICON_XS = new int[]{43, 43, 43};
    private static final int[] ICON_YS = new int[]{35, 73, 110};
    private static final int ICON_SIZE = 32;

    public MainMenuPage(CatalogScreen screen) {
        super(screen);
    }

    @Override
    public void init() {
        super.init();
        List<CatalogData.Category> categories = CatalogData.CATEGORIES;
        int rightPageX = this.screen.getBookX() + 148;
        int rightPageY = this.screen.getBookY() + 5;
        for (int i = 0; i < categories.size(); ++i) {
            CatalogData.Category category = categories.get(i);
            class_2960 iconTexture = this.getCategoryIcon(category.getName());
            if (iconTexture == null) continue;
            int index = i;
            AnimatedIconWidget iconWidget = AnimatedIconWidget.builder(iconTexture, button -> this.selectCategory(index)).position(rightPageX + ICON_XS[i], rightPageY + ICON_YS[i]).displaySize(32).animation(8, 64, 64, 25).tooltip((class_2561)class_2561.method_43471((String)("text.category.resprouted." + category.getName()))).build();
            this.widgets.add(iconWidget);
        }
    }

    @Override
    public void render(PageUtils leftPage, PageUtils rightPage, int mouseX, int mouseY) {
        leftPage.drawIcon(MENU_TITLE, 0, 11, 120, 20);
        leftPage.drawParagraph((class_2561)class_2561.method_43471((String)"text.resprouted.main"), 40, 8549726);
        rightPage.drawIcon(INDEX_TITLE, 15, 11, 91, 20);
    }

    @Override
    public boolean handleClick(double mouseX, double mouseY) {
        return false;
    }

    private void selectCategory(int index) {
        List<CatalogData.Category> categories = CatalogData.CATEGORIES;
        if (index >= 0 && index < categories.size()) {
            CatalogData.Category category = categories.get(index);
            if (this.screen.getSelectedCategory() != category || this.screen.getCurrentState() != CatalogScreen.PageState.CATEGORY_LIST) {
                this.screen.setSelectedCategory(category);
                this.screen.setCurrentState(CatalogScreen.PageState.CATEGORY_LIST);
                this.screen.playPageTurnSound();
            }
        }
    }

    private class_2960 getCategoryIcon(String categoryName) {
        return switch (categoryName) {
            case "agriculture" -> AGRICULTURE_ICON;
            case "decoration" -> DECORATION_ICON;
            case "production" -> PRODUCTION_ICON;
            default -> null;
        };
    }
}

