/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.book.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_5244;

@Environment(value=EnvType.CLIENT)
public class AnimatedIconWidget
extends class_4185 {
    private final class_2960 texture;
    private final int frameCount;
    private final int frameWidth;
    private final int frameHeight;
    private final int frameDuration;
    private final int displaySize;
    private final class_2561 tooltipText;
    private long animationStartTime = -1L;
    private boolean wasHovered = false;

    private AnimatedIconWidget(Builder builder) {
        super(builder.x, builder.y, builder.displaySize, builder.displaySize, class_5244.field_39003, builder.onPress, field_40754);
        this.texture = builder.texture;
        this.frameCount = builder.frameCount;
        this.frameWidth = builder.frameWidth;
        this.frameHeight = builder.frameHeight;
        this.frameDuration = builder.frameDuration;
        this.displaySize = builder.displaySize;
        this.tooltipText = builder.message;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        long elapsed;
        boolean currentlyHovered = this.method_49606();
        if (currentlyHovered && !this.wasHovered) {
            this.animationStartTime = System.currentTimeMillis();
        }
        this.wasHovered = currentlyHovered;
        int frame = 0;
        if (currentlyHovered && this.animationStartTime != -1L && (frame = (int)((elapsed = System.currentTimeMillis() - this.animationStartTime) / (long)this.frameDuration)) >= this.frameCount - 1) {
            frame = this.frameCount - 1;
        }
        context.method_25293(this.texture, this.method_46426(), this.method_46427(), this.displaySize, this.displaySize, 0.0f, (float)(frame * this.frameHeight), this.frameWidth, this.frameHeight, this.frameWidth, this.frameHeight * this.frameCount);
        if (this.method_49606() && this.tooltipText != null && !this.tooltipText.equals((Object)class_5244.field_39003)) {
            context.method_51438(class_310.method_1551().field_1772, this.tooltipText, mouseX, mouseY);
        }
    }

    public void method_25354(class_1144 soundManager) {
        soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
    }

    public static Builder builder(class_2960 texture, class_4185.class_4241 onPress) {
        return new Builder(texture, onPress);
    }

    public static class Builder {
        private final class_2960 texture;
        private final class_4185.class_4241 onPress;
        private int x;
        private int y;
        private int frameCount = 8;
        private int frameWidth = 64;
        private int frameHeight = 64;
        private int frameDuration = 25;
        private int displaySize = 32;
        private class_2561 message = class_5244.field_39003;

        public Builder(class_2960 texture, class_4185.class_4241 onPress) {
            this.texture = texture;
            this.onPress = onPress;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder animation(int frames, int frameWidth, int frameHeight, int duration) {
            this.frameCount = frames;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.frameDuration = duration;
            return this;
        }

        public Builder displaySize(int size) {
            this.displaySize = size;
            return this;
        }

        public Builder tooltip(class_2561 message) {
            this.message = message;
            return this;
        }

        public AnimatedIconWidget build() {
            return new AnimatedIconWidget(this);
        }
    }
}

