/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.compat.jei.JEIVanillaExtensions;
import net.edu.resprouted.compat.jei.category.AdvancedCondenserRecipeCategory;
import net.edu.resprouted.compat.jei.category.BasicCondenserRecipeCategory;
import net.edu.resprouted.compat.jei.category.BrewingBarrelRecipeCategory;
import net.edu.resprouted.compat.jei.category.CrushingTubRecipeCategory;
import net.edu.resprouted.compat.jei.category.DryingBasinRecipeCategory;
import net.edu.resprouted.compat.jei.recipes.ResproutedJEIRecipes;
import net.edu.resprouted.item.ModItems;
import net.edu.resprouted.recipe.custom.AdvancedCondenserRecipe;
import net.edu.resprouted.recipe.custom.BasicCondenserRecipe;
import net.edu.resprouted.recipe.custom.BrewingBarrelRecipe;
import net.edu.resprouted.recipe.custom.CrushingTubRecipe;
import net.edu.resprouted.recipe.custom.DryingBasinRecipe;
import net.edu.resprouted.recipe.custom.JarColoringRecipe;
import net.edu.resprouted.recipe.custom.OliveOilingRecipe;
import net.edu.resprouted.recipe.custom.UrnColoringRecipe;
import net.edu.resprouted.screen.custom.AdvancedCondenserScreen;
import net.edu.resprouted.screen.custom.BasicCondenserScreen;
import net.edu.resprouted.screen.custom.BrewingBarrelScreen;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class JEIPlugin
implements IModPlugin {
    private static final class_2960 ID = class_2960.method_60655((String)"resprouted", (String)"jei_plugin");
    public static final RecipeType<CrushingTubRecipe> CRUSHING_TUB = RecipeType.create((String)"resprouted", (String)"crushing", CrushingTubRecipe.class);
    public static final RecipeType<DryingBasinRecipe> DRYING_BASIN = RecipeType.create((String)"resprouted", (String)"drying", DryingBasinRecipe.class);
    public static final RecipeType<BasicCondenserRecipe> CONDENSER = RecipeType.create((String)"resprouted", (String)"basic_alchemy", BasicCondenserRecipe.class);
    public static final RecipeType<AdvancedCondenserRecipe> ADVANCED_CONDENSER = RecipeType.create((String)"resprouted", (String)"advanced_alchemy", AdvancedCondenserRecipe.class);
    public static final RecipeType<BrewingBarrelRecipe> BREWING_BARREL = RecipeType.create((String)"resprouted", (String)"brewing", BrewingBarrelRecipe.class);

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CRUSHING_TUB, ResproutedJEIRecipes.getCrushingRecipes());
        registration.addRecipes(DRYING_BASIN, ResproutedJEIRecipes.getDryingRecipes());
        registration.addRecipes(CONDENSER, ResproutedJEIRecipes.getBasicAlchemyRecipes());
        registration.addRecipes(ADVANCED_CONDENSER, ResproutedJEIRecipes.getAdvancedAlchemyRecipes());
        registration.addRecipes(BREWING_BARREL, ResproutedJEIRecipes.getBrewingRecipes());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CrushingTubRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingBasinRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BasicCondenserRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AdvancedCondenserRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BrewingBarrelRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(BasicCondenserScreen.class, 63, 40, 29, 5, new RecipeType[]{CONDENSER});
        registration.addRecipeClickArea(AdvancedCondenserScreen.class, 63, 40, 29, 5, new RecipeType[]{ADVANCED_CONDENSER});
        registration.addRecipeClickArea(BrewingBarrelScreen.class, 85, 41, 23, 3, new RecipeType[]{BREWING_BARREL});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.CRUSHING_TUB), new RecipeType[]{CRUSHING_TUB});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.DRYING_BASIN), new RecipeType[]{DRYING_BASIN});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.BASIC_CONDENSER), new RecipeType[]{CONDENSER});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.ADVANCED_CONDENSER), new RecipeType[]{ADVANCED_CONDENSER});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.BREWING_BARREL), new RecipeType[]{BREWING_BARREL});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(OliveOilingRecipe.class, JEIVanillaExtensions.createOilingExtension());
        registration.getCraftingCategory().addExtension(UrnColoringRecipe.class, JEIVanillaExtensions.createUrnColoringExtension());
        registration.getCraftingCategory().addExtension(JarColoringRecipe.class, JEIVanillaExtensions.createJarColoringExtension());
    }

    @NotNull
    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.ELIXIR_BOTTLE, (itemStack, context) -> itemStack.method_57353().toString());
    }
}

