/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.edu.resprouted.block.custom.decorative.JarBlock;
import net.edu.resprouted.block.custom.decorative.UrnBlock;
import net.edu.resprouted.component.ModDataComponentTypes;
import net.edu.resprouted.item.ModItems;
import net.edu.resprouted.recipe.custom.JarColoringRecipe;
import net.edu.resprouted.recipe.custom.OliveOilingRecipe;
import net.edu.resprouted.recipe.custom.UrnColoringRecipe;
import net.edu.resprouted.util.recipe.RecipeUtils;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class JEIVanillaExtensions {
    public static ICraftingCategoryExtension<OliveOilingRecipe> createOilingExtension() {
        return new ICraftingCategoryExtension<OliveOilingRecipe>(){

            public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper craftingGridHelper, @NotNull IFocusGroup focuses) {
                List<class_1799> validFoods = this.getValidFoods();
                if (validFoods.isEmpty()) {
                    return;
                }
                ArrayList<class_1799> foods = new ArrayList<class_1799>();
                ArrayList<class_1799> outPuts = new ArrayList<class_1799>();
                List allFocuses = focuses.getAllFocuses();
                boolean foundSpecificFocus = false;
                for (class_1799 food : validFoods) {
                    class_1799 oiled = food.method_7972();
                    oiled.method_57379(ModDataComponentTypes.OLIVE_OILED, (Object)true);
                    for (IFocus focus : allFocuses) {
                        ITypedIngredient typedIngredient = focus.getTypedValue();
                        if (typedIngredient.getType() != VanillaTypes.ITEM_STACK) continue;
                        class_1799 stack = (class_1799)typedIngredient.getIngredient();
                        if (this.areStacksEqual(stack, food)) {
                            foods.clear();
                            foods.add(food);
                            outPuts.clear();
                            outPuts.add(oiled);
                            foundSpecificFocus = true;
                            break;
                        }
                        if (!this.areStacksEqual(stack, oiled)) continue;
                        foods.clear();
                        foods.add(food);
                        outPuts.clear();
                        outPuts.add(oiled);
                        foundSpecificFocus = true;
                        break;
                    }
                    if (foundSpecificFocus) break;
                    foods.add(food);
                    outPuts.add(oiled);
                }
                ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>();
                inputs.add(foods);
                inputs.add(List.of(new class_1799((class_1935)ModItems.OLIVE_OIL_BOTTLE)));
                craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outPuts);
            }

            private boolean areStacksEqual(class_1799 stack1, class_1799 stack2) {
                if (!stack1.method_31574(stack2.method_7909())) {
                    return false;
                }
                return stack1.method_57353().equals((Object)stack2.method_57353());
            }

            private List<class_1799> getValidFoods() {
                return class_7923.field_41178.method_10220().filter(item -> RecipeUtils.isValidFood(new class_1799((class_1935)item))).map(class_1799::new).collect(Collectors.toList());
            }
        };
    }

    public static ICraftingCategoryExtension<UrnColoringRecipe> createUrnColoringExtension() {
        return new ICraftingCategoryExtension<UrnColoringRecipe>(){

            public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper craftingGridHelper, @NotNull IFocusGroup focuses) {
                List<class_1799> urns = this.getAllUrns();
                ArrayList<class_1799> dyes = new ArrayList<class_1799>();
                ArrayList<class_1799> outputs = new ArrayList<class_1799>();
                Optional inputFocus = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).findFirst();
                Optional outputFocus = focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).findFirst();
                if (inputFocus.isPresent()) {
                    class_1799 focusedInput = (class_1799)((IFocus)inputFocus.get()).getTypedValue().getIngredient();
                    class_1767 dyeColor = null;
                    for (class_1767 color : class_1767.values()) {
                        if (!focusedInput.method_31574((class_1792)class_1769.method_7803((class_1767)color))) continue;
                        dyeColor = color;
                        break;
                    }
                    if (dyeColor != null) {
                        dyes.add(new class_1799((class_1935)class_1769.method_7803(dyeColor)));
                        outputs.add(new class_1799((class_1935)UrnBlock.get(dyeColor)));
                        ArrayList inputs = new ArrayList();
                        inputs.add(urns);
                        inputs.add(dyes);
                        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, (List)inputs, 0, 0);
                        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                    } else {
                        for (class_1767 color : class_1767.values()) {
                            dyes.add(new class_1799((class_1935)class_1769.method_7803((class_1767)color)));
                            outputs.add(new class_1799((class_1935)UrnBlock.get(color)));
                        }
                        ArrayList<class_1799> repeatedUrns = new ArrayList<class_1799>();
                        for (int i = 0; i < dyes.size(); ++i) {
                            repeatedUrns.add(focusedInput.method_7972());
                        }
                        ArrayList<ArrayList<class_1799>> inputs = new ArrayList<ArrayList<class_1799>>();
                        inputs.add(repeatedUrns);
                        inputs.add(dyes);
                        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                    }
                } else if (outputFocus.isPresent()) {
                    class_1799 focusedStack = (class_1799)((IFocus)outputFocus.get()).getTypedValue().getIngredient();
                    class_1767 focusedColor = null;
                    for (class_1767 color : class_1767.values()) {
                        class_1799 coloredUrn = new class_1799((class_1935)UrnBlock.get(color));
                        if (!class_1799.method_31577((class_1799)focusedStack, (class_1799)coloredUrn)) continue;
                        focusedColor = color;
                        break;
                    }
                    if (focusedColor != null) {
                        dyes.add(new class_1799((class_1935)class_1769.method_7803(focusedColor)));
                        outputs.add(new class_1799((class_1935)UrnBlock.get(focusedColor)));
                        ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>();
                        inputs.add(urns);
                        inputs.add(dyes);
                        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                    }
                } else {
                    for (class_1767 color : class_1767.values()) {
                        dyes.add(new class_1799((class_1935)class_1769.method_7803((class_1767)color)));
                        outputs.add(new class_1799((class_1935)UrnBlock.get(color)));
                    }
                    ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>();
                    inputs.add(urns);
                    inputs.add(dyes);
                    craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                    craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                }
            }

            private List<class_1799> getAllUrns() {
                ArrayList<class_1799> urns = new ArrayList<class_1799>();
                urns.add(new class_1799((class_1935)UrnBlock.get(null)));
                for (class_1767 color : class_1767.values()) {
                    urns.add(new class_1799((class_1935)UrnBlock.get(color)));
                }
                return urns;
            }
        };
    }

    public static ICraftingCategoryExtension<JarColoringRecipe> createJarColoringExtension() {
        return new ICraftingCategoryExtension<JarColoringRecipe>(){

            public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper craftingGridHelper, @NotNull IFocusGroup focuses) {
                List<class_1799> jars = this.getAllJars();
                ArrayList<class_1799> dyes = new ArrayList<class_1799>();
                ArrayList<class_1799> outputs = new ArrayList<class_1799>();
                Optional inputFocus = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).findFirst();
                Optional outputFocus = focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).findFirst();
                if (inputFocus.isPresent()) {
                    class_1799 focusedInput = (class_1799)((IFocus)inputFocus.get()).getTypedValue().getIngredient();
                    class_1767 dyeColor = null;
                    for (class_1767 color : class_1767.values()) {
                        if (!focusedInput.method_31574((class_1792)class_1769.method_7803((class_1767)color))) continue;
                        dyeColor = color;
                        break;
                    }
                    if (dyeColor != null) {
                        dyes.add(new class_1799((class_1935)class_1769.method_7803(dyeColor)));
                        outputs.add(new class_1799((class_1935)JarBlock.get(dyeColor)));
                        ArrayList inputs = new ArrayList();
                        inputs.add(jars);
                        inputs.add(dyes);
                        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, (List)inputs, 0, 0);
                        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                    } else {
                        for (class_1767 color : class_1767.values()) {
                            dyes.add(new class_1799((class_1935)class_1769.method_7803((class_1767)color)));
                            outputs.add(new class_1799((class_1935)JarBlock.get(color)));
                        }
                        ArrayList<class_1799> repeatedJars = new ArrayList<class_1799>();
                        for (int i = 0; i < dyes.size(); ++i) {
                            repeatedJars.add(focusedInput.method_7972());
                        }
                        ArrayList<ArrayList<class_1799>> inputs = new ArrayList<ArrayList<class_1799>>();
                        inputs.add(repeatedJars);
                        inputs.add(dyes);
                        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                    }
                } else if (outputFocus.isPresent()) {
                    class_1799 focusedStack = (class_1799)((IFocus)outputFocus.get()).getTypedValue().getIngredient();
                    class_1767 focusedColor = null;
                    for (class_1767 color : class_1767.values()) {
                        class_1799 coloredJar = new class_1799((class_1935)JarBlock.get(color));
                        if (!class_1799.method_31577((class_1799)focusedStack, (class_1799)coloredJar)) continue;
                        focusedColor = color;
                        break;
                    }
                    if (focusedColor != null) {
                        dyes.add(new class_1799((class_1935)class_1769.method_7803(focusedColor)));
                        outputs.add(new class_1799((class_1935)JarBlock.get(focusedColor)));
                        ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>();
                        inputs.add(jars);
                        inputs.add(dyes);
                        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                    }
                } else {
                    for (class_1767 color : class_1767.values()) {
                        dyes.add(new class_1799((class_1935)class_1769.method_7803((class_1767)color)));
                        outputs.add(new class_1799((class_1935)JarBlock.get(color)));
                    }
                    ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>();
                    inputs.add(jars);
                    inputs.add(dyes);
                    craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
                    craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
                }
            }

            private List<class_1799> getAllJars() {
                ArrayList<class_1799> jars = new ArrayList<class_1799>();
                jars.add(new class_1799((class_1935)JarBlock.get(null)));
                for (class_1767 color : class_1767.values()) {
                    jars.add(new class_1799((class_1935)JarBlock.get(color)));
                }
                return jars;
            }
        };
    }
}

