/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.compat.jei.JEIPlugin;
import net.edu.resprouted.recipe.custom.AdvancedCondenserRecipe;
import net.edu.resprouted.util.misc.ElixirUtils;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class AdvancedCondenserRecipeCategory
implements IRecipeCategory<AdvancedCondenserRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable fire;

    public AdvancedCondenserRecipeCategory(IGuiHelper helper) {
        class_2960 texture = class_2960.method_60655((String)"resprouted", (String)"textures/gui/recipe/advanced_condenser_recipe.png");
        this.background = helper.createDrawable(texture, 0, 0, 130, 76);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.ADVANCED_CONDENSER));
        this.arrow = helper.drawableBuilder(texture, 130, 14, 50, 54).buildAnimated(210, IDrawableAnimated.StartDirection.LEFT, false);
        this.fire = helper.drawableBuilder(texture, 130, 0, 14, 14).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, true);
    }

    @NotNull
    public RecipeType<AdvancedCondenserRecipe> getRecipeType() {
        return JEIPlugin.ADVANCED_CONDENSER;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"recipe.resprouted.advanced_alchemy");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AdvancedCondenserRecipe recipe, IFocusGroup focuses) {
        int ingredientCount = recipe.ingredients().size();
        if (ingredientCount >= 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 4, 8).addIngredients(recipe.ingredients().getFirst());
        }
        if (ingredientCount >= 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 4, 32).addIngredients(recipe.ingredients().get(1));
        }
        if (ingredientCount >= 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 4, 56).addIngredients(recipe.ingredients().get(2));
        }
        if (recipe.modifier().isPresent()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 43, 4).addIngredients(recipe.modifier().get());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 82, 4).addItemStack(new class_1799((class_1935)class_1802.field_8469));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 82, 32).addItemStack(ElixirUtils.createElixir(recipe.effect(), recipe.duration(), recipe.amplifier()));
    }

    public void draw(AdvancedCondenserRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.arrow.draw(guiGraphics, 21, 13);
        this.fire.draw(guiGraphics, 44, 43);
    }

    public void getTooltip(ITooltipBuilder tooltip, AdvancedCondenserRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 110.0 && mouseX <= 126.0 && mouseY >= 24.0 && mouseY <= 56.0) {
            tooltip.add((class_5348)class_2561.method_43471((String)"block.minecraft.water"));
            tooltip.add((class_5348)class_2561.method_43470((String)"125/8000 mB").method_27692(class_124.field_1080));
        }
    }
}

