/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.jei.category;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.compat.jei.JEIPlugin;
import net.edu.resprouted.recipe.custom.CrushingTubRecipe;
import net.edu.resprouted.recipe.helper.RecipeOutput;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class CrushingTubRecipeCategory
implements IRecipeCategory<CrushingTubRecipe> {
    private static final IDrawable BASIC_SLOT;
    private static final IDrawable CHANCE_SLOT;
    private final IDrawable background;
    private final IDrawable icon;

    public CrushingTubRecipeCategory(IGuiHelper helper) {
        class_2960 texture = class_2960.method_60655((String)"resprouted", (String)"textures/gui/recipe/crushing_tub_recipe.png");
        this.background = helper.createDrawable(texture, 0, 0, 113, 119);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.CRUSHING_TUB));
    }

    @NotNull
    public RecipeType<CrushingTubRecipe> getRecipeType() {
        return JEIPlugin.CRUSHING_TUB;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"recipe.resprouted.crushing");
    }

    public int getWidth() {
        return 113;
    }

    public int getHeight() {
        return 119;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrushingTubRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 22, 41).addIngredients(recipe.inputItem());
        List<RecipeOutput> outputs = recipe.outputItems();
        boolean hasFluid = recipe.fluidOutput() != null && !recipe.fluidOutput().isBlank();
        int totalOutputs = outputs.size() + (hasFluid ? 1 : 0);
        if (totalOutputs == 0) {
            return;
        }
        int startY = switch (totalOutputs) {
            case 2 -> 40;
            case 3 -> 31;
            case 4 -> 20;
            case 5 -> 11;
            default -> 50;
        };
        int currentSlot = 0;
        int slotSpacing = 21;
        int outputX = 88;
        if (hasFluid) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, outputX, startY).setBackground(BASIC_SLOT, -1, -1).setFluidRenderer(8000L, true, 16, 16).addFluidStack(recipe.fluidOutput().getFluid(), recipe.fluidAmount());
            ++currentSlot;
        }
        for (RecipeOutput output : outputs) {
            if (output.stack().method_7960()) continue;
            int itemY = startY + currentSlot * slotSpacing;
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, outputX, itemY).setBackground(output.chance() < 1.0f ? CHANCE_SLOT : BASIC_SLOT, -1, -1).addItemStack(output.stack());
            if (output.chance() < 1.0f) {
                slot.addTooltipCallback((slotView, tooltip) -> {
                    float chance = output.chance() * 100.0f;
                    String formattedChance = chance % 1.0f == 0.0f ? String.format("%d%%", (int)chance) : String.format("%.1f%%", Float.valueOf(chance));
                    tooltip.add(class_2561.method_43469((String)"recipe.resprouted.crushing.chance", (Object[])new Object[]{formattedChance}).method_27692(class_124.field_1065));
                });
            }
            ++currentSlot;
        }
    }

    public void draw(CrushingTubRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
    }

    static {
        final class_2960 texture = class_2960.method_60655((String)"resprouted", (String)"textures/gui/recipe/crushing_tub_recipe.png");
        BASIC_SLOT = new IDrawable(){

            public int getWidth() {
                return 18;
            }

            public int getHeight() {
                return 18;
            }

            public void draw(class_332 graphics, int xOffset, int yOffset) {
                graphics.method_25290(texture, xOffset, yOffset, 113.0f, 0.0f, 18, 18, 256, 256);
            }
        };
        CHANCE_SLOT = new IDrawable(){

            public int getWidth() {
                return 18;
            }

            public int getHeight() {
                return 18;
            }

            public void draw(class_332 graphics, int xOffset, int yOffset) {
                graphics.method_25290(texture, xOffset, yOffset, 113.0f, 18.0f, 18, 18, 256, 256);
            }
        };
    }
}

