/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.jei.category;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.compat.jei.JEIPlugin;
import net.edu.resprouted.recipe.custom.DryingBasinRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class DryingBasinRecipeCategory
implements IRecipeCategory<DryingBasinRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable timeIcon;

    public DryingBasinRecipeCategory(IGuiHelper helper) {
        class_2960 texture = class_2960.method_60655((String)"resprouted", (String)"textures/gui/recipe/drying_basin_recipe.png");
        this.background = helper.createDrawable(texture, 0, 0, 113, 63);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)ModBlocks.DRYING_BASIN));
        this.arrow = helper.drawableBuilder(texture, 113, 0, 22, 15).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.timeIcon = helper.createDrawable(texture, 135, 0, 9, 12);
    }

    @NotNull
    public RecipeType<DryingBasinRecipe> getRecipeType() {
        return JEIPlugin.DRYING_BASIN;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"recipe.resprouted.drying");
    }

    public int getWidth() {
        return 113;
    }

    public int getHeight() {
        return 63;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingBasinRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 5).setFluidRenderer(6000L, true, 16, 16).addFluidStack(recipe.fluidInput().getFluid(), recipe.fluidCost());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 82, 28).addItemStack(recipe.output());
    }

    public void draw(DryingBasinRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.arrow.draw(guiGraphics, 54, 28);
        this.timeIcon.draw(guiGraphics, 70, 17);
    }

    @NotNull
    public List<class_2561> getTooltipStrings(DryingBasinRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 70.0 && mouseX <= 79.0 && mouseY >= 17.0 && mouseY <= 29.0) {
            int ticks = recipe.craftTime();
            String timeText = this.formatTime(ticks);
            return List.of(class_2561.method_43469((String)"recipe.resprouted.drying.time", (Object[])new Object[]{timeText}));
        }
        return List.of();
    }

    private String formatTime(int ticks) {
        double seconds = (double)ticks / 20.0;
        if (seconds < 60.0) {
            if (seconds == (double)((int)seconds)) {
                return String.format("%ds", (int)seconds);
            }
            return String.format("%.1fs", seconds);
        }
        int minutes = (int)(seconds / 60.0);
        int remainingSeconds = (int)(seconds % 60.0);
        if (remainingSeconds == 0) {
            return String.format("%dm", minutes);
        }
        return String.format("%dm %ds", minutes, remainingSeconds);
    }
}

