/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.rei;

import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.compat.rei.category.AdvancedCondenserCategory;
import net.edu.resprouted.compat.rei.category.BasicCondenserCategory;
import net.edu.resprouted.compat.rei.category.BrewingBarrelCategory;
import net.edu.resprouted.compat.rei.category.CrushingTubCategory;
import net.edu.resprouted.compat.rei.category.DryingBasinCategory;
import net.edu.resprouted.compat.rei.category.JarColoringCategory;
import net.edu.resprouted.compat.rei.category.OliveOilingCategory;
import net.edu.resprouted.compat.rei.category.UrnColoringCategory;
import net.edu.resprouted.compat.rei.category.VantaOilingCategory;
import net.edu.resprouted.compat.rei.display.AdvancedCondenserDisplay;
import net.edu.resprouted.compat.rei.display.BasicCondenserDisplay;
import net.edu.resprouted.compat.rei.display.BrewingBarrelDisplay;
import net.edu.resprouted.compat.rei.display.CrushingTubDisplay;
import net.edu.resprouted.compat.rei.display.DryingBasinDisplay;
import net.edu.resprouted.compat.rei.display.JarColoringDisplay;
import net.edu.resprouted.compat.rei.display.OliveOilingDisplay;
import net.edu.resprouted.compat.rei.display.UrnColoringDisplay;
import net.edu.resprouted.compat.rei.display.VantaOilingDisplay;
import net.edu.resprouted.item.ModItems;
import net.edu.resprouted.recipe.ModRecipes;
import net.edu.resprouted.recipe.custom.AdvancedCondenserRecipe;
import net.edu.resprouted.recipe.custom.BasicCondenserRecipe;
import net.edu.resprouted.recipe.custom.BrewingBarrelRecipe;
import net.edu.resprouted.recipe.custom.CrushingTubRecipe;
import net.edu.resprouted.recipe.custom.DryingBasinRecipe;
import net.edu.resprouted.recipe.custom.OliveOilingRecipe;
import net.edu.resprouted.recipe.custom.VantaOilingRecipe;
import net.edu.resprouted.screen.custom.AdvancedCondenserScreen;
import net.edu.resprouted.screen.custom.BasicCondenserScreen;
import net.edu.resprouted.screen.custom.BrewingBarrelScreen;
import net.edu.resprouted.util.misc.ElixirUtils;
import net.edu.resprouted.util.recipe.RecipeUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class REIClient
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new CrushingTubCategory());
        registry.add((DisplayCategory)new DryingBasinCategory());
        registry.add((DisplayCategory)new BasicCondenserCategory());
        registry.add((DisplayCategory)new AdvancedCondenserCategory());
        registry.add((DisplayCategory)new BrewingBarrelCategory());
        registry.add((DisplayCategory)new OliveOilingCategory());
        registry.add((DisplayCategory)new VantaOilingCategory());
        registry.add((DisplayCategory)new UrnColoringCategory());
        registry.add((DisplayCategory)new JarColoringCategory());
        registry.addWorkstations(BasicCondenserCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.BASIC_CONDENSER)});
        registry.addWorkstations(AdvancedCondenserCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.ADVANCED_CONDENSER)});
        registry.addWorkstations(BrewingBarrelCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.BREWING_BARREL)});
        registry.addWorkstations(OliveOilingCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8465)});
        registry.addWorkstations(VantaOilingCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8465)});
        registry.addWorkstations(UrnColoringCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8465)});
        registry.addWorkstations(JarColoringCategory.ID, new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8465)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(CrushingTubRecipe.class, ModRecipes.CRUSHING_TYPE, CrushingTubDisplay::new);
        registry.registerRecipeFiller(DryingBasinRecipe.class, ModRecipes.DRYING_TYPE, DryingBasinDisplay::new);
        registry.registerRecipeFiller(BasicCondenserRecipe.class, ModRecipes.CONDENSER_TYPE, BasicCondenserDisplay::new);
        registry.registerRecipeFiller(AdvancedCondenserRecipe.class, ModRecipes.ADVANCED_CONDENSER_TYPE, AdvancedCondenserDisplay::new);
        this.registerOliveOilingRecipes(registry);
        this.registerVantaOilingRecipes(registry);
        BrewingBarrelRecipe.RECIPES.forEach(recipe -> registry.add((Display)new BrewingBarrelDisplay((BrewingBarrelRecipe)recipe)));
        for (class_1767 color : class_1767.values()) {
            registry.add((Display)new UrnColoringDisplay(color));
            registry.add((Display)new JarColoringDisplay(color));
        }
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerContainerClickArea(new Rectangle(60, 38, 30, 8), BasicCondenserScreen.class, new CategoryIdentifier[]{BasicCondenserCategory.ID});
        registry.registerContainerClickArea(new Rectangle(60, 38, 30, 8), AdvancedCondenserScreen.class, new CategoryIdentifier[]{AdvancedCondenserCategory.ID});
        registry.registerContainerClickArea(new Rectangle(85, 39, 21, 7), BrewingBarrelScreen.class, new CategoryIdentifier[]{BrewingBarrelCategory.ID});
    }

    public void registerEntries(EntryRegistry registry) {
        if (ModItems.ELIXIR_BOTTLE != null) {
            List<class_1799> elixirs = ElixirUtils.getElixirs();
            for (class_1799 elixir : elixirs) {
                registry.addEntry(EntryStacks.of((class_1799)elixir));
            }
        }
    }

    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerComponents(ModItems.ELIXIR_BOTTLE);
    }

    private void registerOliveOilingRecipes(DisplayRegistry registry) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_1863 recipeManager = world.method_8433();
        boolean hasOliveOilingRecipe = false;
        for (class_8786 entry : recipeManager.method_8126()) {
            if (!(entry.comp_1933() instanceof OliveOilingRecipe)) continue;
            hasOliveOilingRecipe = true;
            break;
        }
        if (!hasOliveOilingRecipe) {
            return;
        }
        List<class_1792> validFoods = class_7923.field_41178.method_10220().filter(item -> RecipeUtils.isValidFood(new class_1799((class_1935)item))).toList();
        for (class_1792 food : validFoods) {
            registry.add((Display)new OliveOilingDisplay(food));
        }
    }

    private void registerVantaOilingRecipes(DisplayRegistry registry) {
        for (int numPotions = 1; numPotions <= 7; ++numPotions) {
            for (class_6880 potionEntry : class_7923.field_41179.method_40295()) {
                class_1842 potion = (class_1842)potionEntry.comp_349();
                if (potion.method_8049().size() != 1) continue;
                registry.add((Display)new VantaOilingDisplay(numPotions, (class_6880<class_1842>)potionEntry));
            }
            if (ModItems.ELIXIR_BOTTLE == null) continue;
            List<class_1799> elixirs = ElixirUtils.getElixirs();
            for (class_1799 elixir : elixirs) {
                class_1293 effect = VantaOilingRecipe.getIngredientEffect(elixir);
                if (effect == null) continue;
                registry.add((Display)new VantaOilingDisplay(numPotions, elixir));
            }
        }
    }
}

