/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.compat.rei.display;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.edu.resprouted.compat.rei.category.VantaOilingCategory;
import net.edu.resprouted.component.ModDataComponentTypes;
import net.edu.resprouted.item.ModItems;
import net.edu.resprouted.recipe.custom.VantaOilingRecipe;
import net.edu.resprouted.util.recipe.RecipeUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class VantaOilingDisplay
extends BasicDisplay {
    private final int numPotions;

    public VantaOilingDisplay(int numPotions, class_6880<class_1842> potionEntry) {
        super(VantaOilingDisplay.getInputsForPotion(numPotions, potionEntry), VantaOilingDisplay.getOutputsForPotion(numPotions, potionEntry));
        this.numPotions = numPotions;
    }

    public VantaOilingDisplay(int numPotions, class_1799 elixir) {
        super(VantaOilingDisplay.getInputsForElixir(numPotions, elixir), VantaOilingDisplay.getOutputsForElixir(numPotions, elixir));
        this.numPotions = numPotions;
    }

    private static List<EntryIngredient> getInputsForPotion(int numPotions, class_6880<class_1842> potionEntry) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        ArrayList<class_1799> weapons = new ArrayList<class_1799>();
        for (class_1792 item : class_7923.field_41178) {
            class_1799 stack = new class_1799((class_1935)item);
            if (!RecipeUtils.isVantaOilableWeapon(stack)) continue;
            weapons.add(stack);
        }
        inputs.add(EntryIngredients.ofItemStacks(weapons));
        inputs.add(EntryIngredients.of((class_1935)ModItems.VANTA_OIL_BOTTLE));
        ArrayList<EntryStack> potionStacks = new ArrayList<EntryStack>();
        potionStacks.add(EntryStacks.of((class_1799)VantaOilingDisplay.createPotionStack(class_1802.field_8574, potionEntry)));
        potionStacks.add(EntryStacks.of((class_1799)VantaOilingDisplay.createPotionStack(class_1802.field_8436, potionEntry)));
        potionStacks.add(EntryStacks.of((class_1799)VantaOilingDisplay.createPotionStack(class_1802.field_8150, potionEntry)));
        for (int i = 0; i < numPotions; ++i) {
            inputs.add(EntryIngredient.of(potionStacks));
        }
        return inputs;
    }

    private static List<EntryIngredient> getInputsForElixir(int numPotions, class_1799 elixir) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        ArrayList<class_1799> weapons = new ArrayList<class_1799>();
        for (class_1792 item : class_7923.field_41178) {
            class_1799 stack = new class_1799((class_1935)item);
            if (!RecipeUtils.isVantaOilableWeapon(stack)) continue;
            weapons.add(stack);
        }
        inputs.add(EntryIngredients.ofItemStacks(weapons));
        inputs.add(EntryIngredients.of((class_1935)ModItems.VANTA_OIL_BOTTLE));
        for (int i = 0; i < numPotions; ++i) {
            inputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((class_1799)elixir)));
        }
        return inputs;
    }

    private static List<EntryIngredient> getOutputsForPotion(int numPotions, class_6880<class_1842> potionEntry) {
        ArrayList<EntryStack> outputs = new ArrayList<EntryStack>();
        class_1842 potion = (class_1842)potionEntry.comp_349();
        if (potion.method_8049().size() == 1) {
            class_1293 effect = (class_1293)potion.method_8049().getFirst();
            for (class_1792 item : class_7923.field_41178) {
                class_1799 stack = new class_1799((class_1935)item);
                if (!RecipeUtils.isVantaOilableWeapon(stack)) continue;
                class_1799 oiled = stack.method_7972();
                oiled.method_7939(1);
                int totalDuration = effect.method_5584() * numPotions;
                class_1293 vantaEffect = new class_1293(effect.method_5579(), totalDuration, effect.method_5578());
                oiled.method_57379(ModDataComponentTypes.VANTA_OILED, (Object)vantaEffect);
                outputs.add(EntryStacks.of((class_1799)oiled));
            }
        }
        return List.of(EntryIngredient.of(outputs));
    }

    private static List<EntryIngredient> getOutputsForElixir(int numPotions, class_1799 elixir) {
        ArrayList<EntryStack> outputs = new ArrayList<EntryStack>();
        class_1293 effect = VantaOilingRecipe.getIngredientEffect(elixir);
        if (effect != null) {
            for (class_1792 item : class_7923.field_41178) {
                class_1799 stack = new class_1799((class_1935)item);
                if (!RecipeUtils.isVantaOilableWeapon(stack)) continue;
                class_1799 oiled = stack.method_7972();
                oiled.method_7939(1);
                int totalDuration = effect.method_5584() * numPotions;
                class_1293 vantaEffect = new class_1293(effect.method_5579(), totalDuration, effect.method_5578());
                oiled.method_57379(ModDataComponentTypes.VANTA_OILED, (Object)vantaEffect);
                outputs.add(EntryStacks.of((class_1799)oiled));
            }
        }
        return List.of(EntryIngredient.of(outputs));
    }

    private static class_1799 createPotionStack(class_1792 basePotionItem, class_6880<class_1842> potionEntry) {
        class_1799 stack = new class_1799((class_1935)basePotionItem);
        stack.method_57379(class_9334.field_49651, (Object)new class_1844(potionEntry));
        return stack;
    }

    public int getNumPotions() {
        return this.numPotions;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return VantaOilingCategory.ID;
    }
}

